/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/internal/task/runcommercialtask.h"

namespace {
#define CHANNEL_ID_TEMPLATE "{channel_id}"
const char* kChannelNameTemplate = CHANNEL_ID_TEMPLATE;
const char* kCommercialURL = "https://api.twitch.tv/kraken/channels/" CHANNEL_ID_TEMPLATE "/commercial";
}  // namespace

// curl -X POST -H "Client-Id: $CLIENTID" -H "Accept: application/vnd.twitchtv.v5+json" -H "Authorization: OAuth $OAUTH"
// "https://api.twitch.tv/kraken/channels/$CHANNELID/commercial" | python -m json.tool

ttv::broadcast::RunCommercialTask::RunCommercialTask(
  ChannelId channelId, const std::string& authToken, Callback callback)
    : HttpTask(nullptr, nullptr, authToken.c_str()), mCallback(callback), mChannelId(channelId) {
  ttv::trace::Message(GetTaskName(), MessageLevel::Info, "RunCommercialTask created");
}

void ttv::broadcast::RunCommercialTask::FillHttpRequestInfo(HttpRequestInfo& requestInfo) {
  requestInfo.url = kCommercialURL;
  (void)requestInfo.url.replace(
    requestInfo.url.find(kChannelNameTemplate), strlen(kChannelNameTemplate), std::to_string(mChannelId));

  requestInfo.httpReqType = HTTP_POST_REQUEST;
  requestInfo.requestHeaders.emplace_back("Accept", "application/vnd.twitchtv.v5+json");
}

void ttv::broadcast::RunCommercialTask::OnComplete() {
  if (mCallback) {
    if (mAborted) {
      mTaskStatus = TTV_EC_REQUEST_ABORTED;
    }

    mCallback(this, mTaskStatus.ec, mResult);
  }
}
