/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/internal/task/setstreaminfotask.h"

#include "twitchsdk/core/json/writer.h"

#include <sstream>

namespace {
const char* kStreamInfoBaseURL = "https://api.twitch.tv/kraken/channels/";
}

ttv::broadcast::SetStreamInfoTask::SetStreamInfoTask(ChannelId channelId, const std::string& oauthToken,
  const std::string& streamTitle, const std::string& gameName, Callback callback)
    : HttpTask(oauthToken), mCallback(callback), mChannelId(channelId), mStreamTitle(streamTitle), mGameName(gameName) {
  ttv::trace::Message(GetTaskName(), MessageLevel::Info, "SetStreamInfoTask created");
}

void ttv::broadcast::SetStreamInfoTask::FillHttpRequestInfo(HttpRequestInfo& requestInfo) {
  requestInfo.url = kStreamInfoBaseURL + std::to_string(mChannelId);
  requestInfo.httpReqType = HTTP_PUT_REQUEST;

  ttv::json::Value data;
  auto& channel = data["channel"];

  if (mStreamTitle != "") {
    channel["status"] = mStreamTitle;
  }
  if (mGameName != "") {
    channel["game"] = mGameName;
  }

  json::FastWriter writer;
  requestInfo.requestBody = writer.write(data);

  requestInfo.requestHeaders.emplace_back("Accept", "application/vnd.twitchtv.v5+json");
  requestInfo.requestHeaders.emplace_back("Content-Type", "application/json");
}

void ttv::broadcast::SetStreamInfoTask::OnComplete() {
  if (mCallback) {
    if (mAborted) {
      mTaskStatus = TTV_EC_REQUEST_ABORTED;
    }

    mCallback(this, mTaskStatus.ec, mResult);
  }
}
