/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/eventsource.h"
#include "twitchsdk/core/types/coretypes.h"

#include <vector>

namespace ttv {
class ISocket;

namespace test {
class TestSocket;
}

namespace broadcast {
namespace test {
namespace amf0 {
enum class Amf0Type : uint8_t {
  Number = 0x00,
  Boolean = 0x01,
  String = 0x02,
  Object = 0x03,
  EcmaArray = 0x08,
  ObjectEnd = 0x09,
  StrictArray = 0x0A,
  Date = 0x0B,
  Null = 0x05,
  Undefined = 0x06,
  Reference = 0x07,
  LongString = 0x0C,
  XmlDocument = 0x0F,
  TypedObject = 0x10,
  Movieclip = 0x04,
  RecordSet = 0x0E,
  Unsupported = 0x0D
};

struct Amf0Object;

struct Amf0Value {
  Amf0Value();
  explicit Amf0Value(bool b);
  explicit Amf0Value(double n);
  explicit Amf0Value(uint32_t n);
  explicit Amf0Value(const char* str);
  explicit Amf0Value(const std::string& str);
  explicit Amf0Value(const std::shared_ptr<Amf0Object>& obj);
  ~Amf0Value();

  Amf0Value(const Amf0Value& other);

  Amf0Type type;
  std::shared_ptr<Amf0Object> object;
  std::string str;
  double number;
  bool boolean;
};

struct Amf0Object {
  std::vector<std::pair<std::string, std::shared_ptr<Amf0Value>>> properties;
};

bool ParseAmf0Value(std::vector<uint8_t>& buffer, Amf0Value& value);
bool ParseAmf0String(std::vector<uint8_t>& buffer, Amf0Value& value);
bool ParseAmf0Object(std::vector<uint8_t>& buffer, Amf0Object& value);

void WriteAmf0Value(std::vector<uint8_t>& buffer, const Amf0Value& value, bool writeType = true);
void WriteAmf0String(std::vector<uint8_t>& buffer, const std::string& value);
void WriteAmf0String(std::vector<uint8_t>& buffer, const Amf0Value& value);
void WriteAmf0Number(std::vector<uint8_t>& buffer, const Amf0Value& value);
void WriteAmf0Boolean(std::vector<uint8_t>& buffer, const Amf0Value& value);
void WriteAmf0Object(std::vector<uint8_t>& buffer, const Amf0Object& value);
}  // namespace amf0
}  // namespace test
}  // namespace broadcast
}  // namespace ttv
