/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "testhttprequest.h"
#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/user/userrepository.h"

namespace ttv {
namespace broadcast {
namespace test {
class BroadcastTestUtility;
}
}  // namespace broadcast
}  // namespace ttv

class ttv::broadcast::test::BroadcastTestUtility {
 public:
  void SetUpStubs(std::shared_ptr<TestHttpRequest> testHttpRequest);
  void SetUpComponents(std::shared_ptr<ttv::UserRepository> userRepository);
  void TearDownComponents();
  void TearDownStubs();

  static json::Value JsonForChannelInfo(
    const std::string& channelName, const std::string& displayName, const std::string& streamKey);
  static std::string CreateRtmpUrl(const std::string& urlTemplate, const std::string& streamKey);

 private:
};
