/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/types/coretypes.h"

#include <vector>

namespace ttv {
namespace broadcast {
namespace test {
using uint24_t = uint8_t[3];

uint32_t EndianSwap(uint32_t source);
uint32_t EndianSwap(uint24_t source);

uint32_t ReadUInt16(std::vector<uint8_t>& buffer, size_t offset = 0, bool consume = true);
uint32_t ReadUInt24(std::vector<uint8_t>& buffer, size_t offset = 0, bool consume = true);
uint32_t ReadUInt32(std::vector<uint8_t>& buffer, size_t offset = 0, bool consume = true);
double ReadDouble(std::vector<uint8_t>& buffer, size_t offset = 0, bool consume = true);
std::string ReadString(std::vector<uint8_t>& buffer, size_t length, size_t offset = 0, bool consume = true);

template <typename T>
T ReadByte(std::vector<uint8_t>& buffer, size_t offset = 0, bool consume = true) {
  T result = static_cast<T>(buffer[offset]);

  if (consume) {
    buffer.erase(buffer.begin(), buffer.begin() + 1);
  }

  return result;
}

void WriteUInt16(std::vector<uint8_t>& buffer, uint16_t value);
void WriteUInt24(std::vector<uint8_t>& buffer, uint32_t value);
void WriteUInt32(std::vector<uint8_t>& buffer, uint32_t value);
void WriteDouble(std::vector<uint8_t>& buffer, double value);
void WriteString(std::vector<uint8_t>& buffer, const std::string& str, bool writeNull = false);

template <typename T>
void WriteByte(std::vector<uint8_t>& buffer, T value) {
  buffer.push_back(static_cast<uint8_t>(value));
}
}  // namespace test
}  // namespace broadcast
}  // namespace ttv
