/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "broadcasttestutility.h"

#include "testutilities.h"
#include "twitchsdk/core/json/writer.h"
#include "twitchsdk/core/stringutilities.h"

void ttv::broadcast::test::BroadcastTestUtility::SetUpStubs(std::shared_ptr<TestHttpRequest> /*testHttpRequest*/) {
  // for (const auto& userInfo : mUserInfos)
  //{
  //  ttv::json::FastWriter writer;
  //  testHttpRequest->AddResponse("https://api.twitch.tv/kraken/users/" + userInfo.userName)
  //      .SetResponseBody((JsonForUserInfo(userInfo)))
  //      .Done();
  //}
}

void ttv::broadcast::test::BroadcastTestUtility::SetUpComponents(
  std::shared_ptr<ttv::UserRepository> /*userRepository*/) {}

void ttv::broadcast::test::BroadcastTestUtility::TearDownComponents() {}

void ttv::broadcast::test::BroadcastTestUtility::TearDownStubs() {}

ttv::json::Value ttv::broadcast::test::BroadcastTestUtility::JsonForChannelInfo(
  const std::string& channelName, const std::string& displayName, const std::string& streamKey) {
  ttv::json::Value value;

  value["name"] = channelName;
  value["display_name"] = displayName;
  value["stream_key"] = streamKey;

  return value;
}

std::string ttv::broadcast::test::BroadcastTestUtility::CreateRtmpUrl(
  const std::string& urlTemplate, const std::string& streamKey) {
  std::string url = urlTemplate;

  const char* kStreamKeyTemplate = "{stream_key}";
  size_t replacePos = urlTemplate.find(kStreamKeyTemplate);
  TTV_ASSERT(replacePos != std::string::npos);
  if (replacePos != std::string::npos) {
    url.replace(replacePos, strlen(kStreamKeyTemplate), streamKey);
  }

  return url;
}
