#include "twitchsdk/broadcast/generated/getstreamkey.h"
#include "twitchsdk/core/json/reader.h"
#include "twitchsdk/core/json/value.h"

#include "gtest/gtest.h"

namespace ttv {
namespace broadcast {
namespace test {
namespace {

graphql::GetStreamKeyQueryInfo::PayloadType Parse(const std::string& payload) {
  json::Value data;

  EXPECT_TRUE(json::Reader().parse(payload, data));

  graphql::GetStreamKeyQueryInfo::PayloadType domainObject;

  EXPECT_TRUE(ToObject(data, domainObject));

  return domainObject;
}

}  // namespace

TEST(GetStreamKeyTests, StreamKeyValid) {
  auto payload =
    R"({
      "user": {
        "id": "id",
        "profileURL": "profile_url",
        "displayName": "display_name",
        "login": "login",
        "channel": {
          "videoStreamSettings": {
            "streamKey": {
              "__typename": "StreamKey",
              "value": "stream_key_value"
            }
          }
        }
      }
    })";

  auto streamKeyObject = Parse(payload);
  auto streamkeyResult = streamKeyObject.channel.ValueOrDefault({}).videoStreamSettings.ValueOrDefault({}).streamKey;
  EXPECT_EQ(streamkeyResult.__typename, "StreamKey");
  EXPECT_TRUE(streamkeyResult.streamKeyVariant.Is<graphql::GetStreamKeyQueryInfo::StreamKey>());

  auto streamKey = streamkeyResult.streamKeyVariant.As<graphql::GetStreamKeyQueryInfo::StreamKey>();
  EXPECT_EQ(streamKey.value, "stream_key_value");
}

TEST(GetStreamKeyTests, StreamKeyError) {
  auto payload =
    R"({
      "user": {
        "id": "id",
        "profileURL": "profile_url",
        "displayName": "display_name",
        "login": "login",
        "channel": {
          "videoStreamSettings": {
            "streamKey": {
              "__typename": "StreamKeyError",
              "code": "error_code",
              "message": "error_message",
              "links": [
                "error_link_0",
                "error_link_1"
              ]
            }
          }
        }
      }
    })";

  auto streamKeyObject = Parse(payload);
  auto streamkeyResult = streamKeyObject.channel.Value().videoStreamSettings.Value().streamKey;
  EXPECT_EQ(streamkeyResult.__typename, "StreamKeyError");
  EXPECT_TRUE(streamkeyResult.streamKeyVariant.Is<graphql::GetStreamKeyQueryInfo::StreamKeyError>());

  auto streamKeyError = streamkeyResult.streamKeyVariant.As<graphql::GetStreamKeyQueryInfo::StreamKeyError>();
  EXPECT_EQ(streamKeyError.code, "error_code");
  EXPECT_EQ(streamKeyError.message, "error_message");
  ASSERT_EQ(streamKeyError.links.size(), 2);
  EXPECT_EQ(streamKeyError.links[0], "error_link_0");
  EXPECT_EQ(streamKeyError.links[1], "error_link_1");
}

}  // namespace test
}  // namespace broadcast
}  // namespace ttv
