/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk.h"

#if TTV_PLATFORM_MAC
#define EXPORT_API __attribute__((visibility("default")))
#else
#define EXPORT_API
#endif

namespace ttv {
struct ManagedBroadcastAPIListener {
 public:
  ManagedBroadcastAPIListener();

  void FireRequestAuthTokenCallback(TTV_ErrorCode ec, const TTV_AuthToken* result);
  void FireLoginCallback(TTV_ErrorCode ec, const TTV_ChannelInfo* result);
  void FireGetIngestListCallback(TTV_ErrorCode ec, TTV_IngestList* result);
  void FireGetUserInfoCallback(TTV_ErrorCode ec, const TTV_UserInfo___* result);
  void FireGetStreamInfoCallback(TTV_ErrorCode ec, const TTV_StreamInfo* result);
  void FireGetArchivingStateCallback(TTV_ErrorCode ec, const TTV_ArchivingState* result);
  void FireRunCommercialCallback(TTV_ErrorCode ec);
  void FireGetGameLiveStreamsCallback(TTV_ErrorCode ec, const TTV_LiveGameStreamList* result);
  void FireGetGameNameListCallback(TTV_ErrorCode ec, const TTV_GameInfoList* result);
  void FireStartCallback(TTV_ErrorCode ec);
  void FireStopCallback(TTV_ErrorCode ec);
  void FireSendActionMetaDataCallback(TTV_ErrorCode ec);
  void FireSendStartSpanMetaDataCallback(TTV_ErrorCode ec);
  void FireSendEndSpanMetaDataCallback(TTV_ErrorCode ec);
  void FireSetStreamInfoCallback(TTV_ErrorCode ec);
  void FireBufferUnlockCallback(const uint8_t* buffer);

// TODO: revisit how to split this into separate files
#if !TTV_PLATFORM_UNITYIOS
 private:
  typedef void (*TTV_CSharp_RequestAuthTokenCallback)(TTV_ErrorCode ec, const TTV_AuthToken* result);
  typedef void (*TTV_CSharp_LoginCallback)(TTV_ErrorCode ec, const TTV_ChannelInfo* result);
  typedef void (*TTV_CSharp_GetIngestListCallback)(TTV_ErrorCode ec, const TTV_IngestList* result);
  typedef void (*TTV_CSharp_GetUserInfoCallback)(TTV_ErrorCode ec, const TTV_UserInfo___* result);
  typedef void (*TTV_CSharp_GetStreamInfoCallback)(TTV_ErrorCode ec, const TTV_StreamInfo* result);
  typedef void (*TTV_CSharp_GetArchivingStateCallback)(TTV_ErrorCode ec, const TTV_ArchivingState* result);
  typedef void (*TTV_CSharp_RunCommercialCallback)(TTV_ErrorCode ec);
  typedef void (*TTV_CSharp_GetGameLiveStreamsCallback)(TTV_ErrorCode ec, const TTV_LiveGameStreamList* result);
  typedef void (*TTV_CSharp_GetGameNameListCallback)(TTV_ErrorCode ec, const TTV_GameInfoList* result);
  typedef void (*TTV_CSharp_StartCallback)(TTV_ErrorCode ec);
  typedef void (*TTV_CSharp_StopCallback)(TTV_ErrorCode ec);
  typedef void (*TTV_CSharp_SendActionMetaDataCallback)(TTV_ErrorCode ec);
  typedef void (*TTV_CSharp_SendStartSpanMetaDataCallback)(TTV_ErrorCode ec);
  typedef void (*TTV_CSharp_SendEndSpanMetaDataCallback)(TTV_ErrorCode ec);
  typedef void (*TTV_CSharp_SetStreamInfoCallback)(TTV_ErrorCode ec);
  typedef void (*TTV_CSharp_BufferUnlockCallback)(const uint8_t* buffer);

  TTV_CSharp_RequestAuthTokenCallback requestAuthTokenCallback;
  TTV_CSharp_LoginCallback loginCallback;
  TTV_CSharp_GetIngestListCallback getIngestListCallback;
  TTV_CSharp_GetUserInfoCallback getUserInfoCallback;
  TTV_CSharp_GetStreamInfoCallback getStreamInfoCallback;
  TTV_CSharp_GetArchivingStateCallback getArchivingStateCallback;
  TTV_CSharp_RunCommercialCallback runCommercialCallback;
  // TTV_CSharp_GetGameLiveStreamsCallback getGameLiveStreamsCallback;
  TTV_CSharp_GetGameNameListCallback getGameNameListCallback;
  TTV_CSharp_StartCallback startCallback;
  TTV_CSharp_StopCallback stopCallback;
  TTV_CSharp_SendActionMetaDataCallback sendActionMetaDataCallback;
  TTV_CSharp_SendStartSpanMetaDataCallback sendStartSpanMetaDataCallback;
  TTV_CSharp_SendEndSpanMetaDataCallback sendEndSpanMetaDataCallback;
  TTV_CSharp_SetStreamInfoCallback setStreamInfoCallback;
  TTV_CSharp_BufferUnlockCallback bufferUnlockCallback;
#endif
};

struct ManagedStatsListener {
 public:
  ManagedStatsListener();

  void FireStatCallback(TTV_StatType type, uint64_t data);

  // TODO: revisit how to split this into separate files
#if !TTV_PLATFORM_UNITYIOS
 private:
  typedef void (*TTV_CSharp_StatCallback)(TTV_StatType type, uint64_t data);

  TTV_CSharp_StatCallback statCallback;
#endif
};

extern "C" TTV_ErrorCode TTV_CSharp_Broadcast_FreeAuthToken(const TTV_AuthToken* authToken);
extern "C" TTV_ErrorCode TTV_CSharp_Broadcast_FreeIngestList(TTV_IngestList* ingestList);
extern "C" TTV_ErrorCode TTV_CSharp_Broadcast_FreeChannelInfo(const TTV_ChannelInfo* channelInfo);
extern "C" TTV_ErrorCode TTV_CSharp_Broadcast_FreeStreamInfo(const TTV_StreamInfo* streamInfo);
extern "C" TTV_ErrorCode TTV_CSharp_Broadcast_FreeGameNameList(const TTV_GameInfoList* gameList);
extern "C" TTV_ErrorCode TTV_CSharp_Broadcast_GetStreamTime(uint64_t* timeMs);
extern "C" TTV_ErrorCode TTV_CSharp_Broadcast_FreeUserInfo(const TTV_UserInfo___* userInfo);
extern "C" TTV_ErrorCode TTV_CSharp_Broadcast_FreeArchivingState(const TTV_ArchivingState* state);

// These are declared in csharp_broadcast.cpp
extern ManagedBroadcastAPIListener gManagedBroadcastAPIListener;
extern ManagedStatsListener gManagedStatsListener;
extern bool gBroadcastInitialized;
}  // namespace ttv
