/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "internal/pch.h"

#include "internal/bindings/csharp/csharp_broadcast.h"
#include "twitchsdk.h"
#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/json/writer.h"

#if TTV_PLATFORM_UNITYIOS

using namespace ttv::Json;

#ifdef __cplusplus
extern "C" {
#endif
void UnitySendMessage(const char* obj, const char* method, const char* msg);
#ifdef __cplusplus
}
#endif

namespace {
const char* kUnityCallbackObjectName = "Broadcast";
}

// Callbacks in Unity-iOS work very differently than in regular .Net and Unity.
// Unity on iOS does not have full support for callbacks from native to managed.  However, it does allow you to send a
// message to a specifically named game object which is what we will use to pass callback data.
//
// Here we're passing a pointer address to a struct containing the callback data as a string.  In managed you then
// marshal the pointer value to the expected result type and pull out values that way.  The problem is that the message
// won't be executed in managed synchronously so there will need to be a function to free the callback result.
// Maybe also encode in root for simple types

ttv::ManagedBroadcastAPIListener::ManagedBroadcastAPIListener() {
  // NOTE: this is fine as long as there are no virtual functions
  memset(this, 0, sizeof(*this));
}

void ttv::ManagedBroadcastAPIListener::FireRequestAuthTokenCallback(TTV_ErrorCode ec, const TTV_AuthToken* result) {
  Value root;
  root["ec"] = Value(static_cast<int64_t>(ec));
  root["result"] = Value(reinterpret_cast<int64_t>(result));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxyRequestAuthTokenCallback", json.c_str());
}

void ttv::ManagedBroadcastAPIListener::FireLoginCallback(TTV_ErrorCode ec, const TTV_ChannelInfo* result) {
  Value root;
  root["ec"] = Value(static_cast<int64_t>(ec));
  root["result"] = Value(reinterpret_cast<int64_t>(result));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxyLoginCallback", json.c_str());
}

void ttv::ManagedBroadcastAPIListener::FireGetIngestListCallback(TTV_ErrorCode ec, TTV_IngestList* result) {
  Value root;
  root["ec"] = Value(static_cast<int64_t>(ec));
  root["result"] = Value(reinterpret_cast<int64_t>(result));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxyGetIngestListCallback", json.c_str());
}

void ttv::ManagedBroadcastAPIListener::FireGetUserInfoCallback(TTV_ErrorCode ec, const TTV_UserInfo___* result) {
  Value root;
  root["ec"] = Value(static_cast<int64_t>(ec));
  root["result"] = Value(reinterpret_cast<int64_t>(result));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxyGetUserInfoCallback", json.c_str());
}

void ttv::ManagedBroadcastAPIListener::FireGetStreamInfoCallback(TTV_ErrorCode ec, const TTV_StreamInfo* result) {
  Value root;
  root["ec"] = Value(static_cast<int64_t>(ec));
  root["result"] = Value(reinterpret_cast<int64_t>(result));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxyGetStreamInfoCallback", json.c_str());
}

void ttv::ManagedBroadcastAPIListener::FireGetArchivingStateCallback(
  TTV_ErrorCode ec, const TTV_ArchivingState* result) {
  Value root;
  root["ec"] = Value(static_cast<int64_t>(ec));
  root["result"] = Value(reinterpret_cast<int64_t>(result));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxyGetArchivingStateCallback", json.c_str());
}

void ttv::ManagedBroadcastAPIListener::FireRunCommercialCallback(TTV_ErrorCode ec) {
  Value root;
  root["ec"] = Value(static_cast<int64_t>(ec));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxyRunCommercialCallback", json.c_str());
}

void ttv::ManagedBroadcastAPIListener::FireGetGameLiveStreamsCallback(
  TTV_ErrorCode ec, const TTV_LiveGameStreamList* result) {
  Value root;
  root["ec"] = Value(static_cast<int64_t>(ec));
  root["result"] = Value(reinterpret_cast<int64_t>(result));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxyGetGameLiveStreamsCallback", json.c_str());
}

void ttv::ManagedBroadcastAPIListener::FireGetGameNameListCallback(TTV_ErrorCode ec, const TTV_GameInfoList* result) {
  Value root;
  root["ec"] = Value(static_cast<int64_t>(ec));
  root["result"] = Value(reinterpret_cast<int64_t>(result));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxyGetGameNameListCallback", json.c_str());
}

void ttv::ManagedBroadcastAPIListener::FireStartCallback(TTV_ErrorCode ec) {
  Value root;
  root["ec"] = Value(static_cast<int64_t>(ec));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxyStartCallback", json.c_str());
}

void ttv::ManagedBroadcastAPIListener::FireStopCallback(TTV_ErrorCode ec) {
  Value root;
  root["ec"] = Value(static_cast<int64_t>(ec));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxyStopCallback", json.c_str());
}

void ttv::ManagedBroadcastAPIListener::FireSendActionMetaDataCallback(TTV_ErrorCode ec) {
  Value root;
  root["ec"] = Value(static_cast<int64_t>(ec));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxySendActionMetaDataCallback", json.c_str());
}

void ttv::ManagedBroadcastAPIListener::FireSendStartSpanMetaDataCallback(TTV_ErrorCode ec) {
  Value root;
  root["ec"] = Value(static_cast<int64_t>(ec));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxySendStartSpanMetaDataCallback", json.c_str());
}

void ttv::ManagedBroadcastAPIListener::FireSendEndSpanMetaDataCallback(TTV_ErrorCode ec) {
  Value root;
  root["ec"] = Value(static_cast<int64_t>(ec));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxySendEndSpanMetaDataCallback", json.c_str());
}

void ttv::ManagedBroadcastAPIListener::FireSetStreamInfoCallback(TTV_ErrorCode ec) {
  Value root;
  root["ec"] = Value(static_cast<int64_t>(ec));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxySetStreamInfoCallback", json.c_str());
}

void ttv::ManagedBroadcastAPIListener::FireBufferUnlockCallback(const uint8_t* buffer) {
  Value root;
  root["buffer"] = Value(reinterpret_cast<int64_t>(buffer));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxyBufferUnlockCallback", json.c_str());
}

ttv::ManagedStatsListener::ManagedStatsListener() {
  // NOTE: this is fine as long as there are no virtual functions
  memset(this, 0, sizeof(*this));
}

void ttv::ManagedStatsListener::FireStatCallback(TTV_StatType type, uint64_t data) {
  Value root;
  root["type"] = Value(static_cast<int64_t>(type));
  root["data"] = Value(static_cast<int64_t>(data));

  FastWriter writer;
  std::string json = writer.write(root);

  UnitySendMessage(kUnityCallbackObjectName, "ProxyStatCallback", json.c_str());
}

#endif
