/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "internal/pch.h"

#include "internal/bindings/csharp/csharp_broadcast.h"
#include "twitchsdk.h"

#if !TTV_PLATFORM_UNITYIOS

ttv::ManagedBroadcastAPIListener::ManagedBroadcastAPIListener() {
  // NOTE: this is fine as long as there are no virtual functions
  memset(this, 0, sizeof(*this));
}

void ttv::ManagedBroadcastAPIListener::FireRequestAuthTokenCallback(TTV_ErrorCode ec, const TTV_AuthToken* result) {
  if (requestAuthTokenCallback != nullptr) {
    requestAuthTokenCallback(ec, result);
  }

  TTV_CSharp_Broadcast_FreeAuthToken(result);
}

void ttv::ManagedBroadcastAPIListener::FireLoginCallback(TTV_ErrorCode ec, const TTV_ChannelInfo* result) {
  if (loginCallback != nullptr) {
    loginCallback(ec, result);
  }

  TTV_CSharp_Broadcast_FreeChannelInfo(result);
}

void ttv::ManagedBroadcastAPIListener::FireGetIngestListCallback(TTV_ErrorCode ec, TTV_IngestList* result) {
  if (getIngestListCallback != nullptr) {
    getIngestListCallback(ec, result);
  }

  TTV_CSharp_Broadcast_FreeIngestList(result);
}

void ttv::ManagedBroadcastAPIListener::FireGetUserInfoCallback(TTV_ErrorCode ec, const TTV_UserInfo___* result) {
  if (getUserInfoCallback != nullptr) {
    getUserInfoCallback(ec, result);
  }

  TTV_CSharp_Broadcast_FreeUserInfo(result);
}

void ttv::ManagedBroadcastAPIListener::FireGetStreamInfoCallback(TTV_ErrorCode ec, const TTV_StreamInfo* result) {
  if (getStreamInfoCallback != nullptr) {
    getStreamInfoCallback(ec, result);
  }

  TTV_CSharp_Broadcast_FreeStreamInfo(result);
}

void ttv::ManagedBroadcastAPIListener::FireGetArchivingStateCallback(
  TTV_ErrorCode ec, const TTV_ArchivingState* result) {
  if (getArchivingStateCallback != nullptr) {
    getArchivingStateCallback(ec, result);
  }

  TTV_CSharp_Broadcast_FreeArchivingState(result);
}

void ttv::ManagedBroadcastAPIListener::FireRunCommercialCallback(TTV_ErrorCode ec) {
  if (runCommercialCallback != nullptr) {
    runCommercialCallback(ec);
  }
}

void ttv::ManagedBroadcastAPIListener::FireGetGameLiveStreamsCallback(
  TTV_ErrorCode /*ec*/, const TTV_LiveGameStreamList* /*result*/) {
  // if (getGameLiveStreamsCallback != nullptr)
  //{
  //  getGameLiveStreamsCallback(ec, result);
  //}

  // TTV_CSharp_Broadcast_FreeLiveGameStreamList(result);
}

void ttv::ManagedBroadcastAPIListener::FireGetGameNameListCallback(TTV_ErrorCode ec, const TTV_GameInfoList* result) {
  if (getGameNameListCallback != nullptr) {
    getGameNameListCallback(ec, result);
  }

  TTV_CSharp_Broadcast_FreeGameNameList(result);
}

void ttv::ManagedBroadcastAPIListener::FireStartCallback(TTV_ErrorCode ec) {
  if (startCallback != nullptr) {
    startCallback(ec);
  }
}

void ttv::ManagedBroadcastAPIListener::FireStopCallback(TTV_ErrorCode ec) {
  if (stopCallback != nullptr) {
    stopCallback(ec);
  }
}

void ttv::ManagedBroadcastAPIListener::FireSendActionMetaDataCallback(TTV_ErrorCode ec) {
  if (sendActionMetaDataCallback != nullptr) {
    sendActionMetaDataCallback(ec);
  }
}

void ttv::ManagedBroadcastAPIListener::FireSendStartSpanMetaDataCallback(TTV_ErrorCode ec) {
  if (sendStartSpanMetaDataCallback != nullptr) {
    sendStartSpanMetaDataCallback(ec);
  }
}

void ttv::ManagedBroadcastAPIListener::FireSendEndSpanMetaDataCallback(TTV_ErrorCode ec) {
  if (sendEndSpanMetaDataCallback != nullptr) {
    sendEndSpanMetaDataCallback(ec);
  }
}

void ttv::ManagedBroadcastAPIListener::FireSetStreamInfoCallback(TTV_ErrorCode ec) {
  if (setStreamInfoCallback != nullptr) {
    setStreamInfoCallback(ec);
  }
}

void ttv::ManagedBroadcastAPIListener::FireBufferUnlockCallback(const uint8_t* buffer) {
  if (bufferUnlockCallback != nullptr) {
    bufferUnlockCallback(buffer);
  }
}

ttv::ManagedStatsListener::ManagedStatsListener() {
  // NOTE: this is fine as long as there are no virtual functions
  memset(this, 0, sizeof(*this));
}

void ttv::ManagedStatsListener::FireStatCallback(TTV_StatType type, uint64_t data) {
  if (statCallback != nullptr) {
    statCallback(type, data);
  }
}

#endif
