##########################################################################################################
#
# Fragment: broadcast_darwin
#
##########################################################################################################

import os
import glob
import build_types
import build_tools

def load_twitchsdk_fragment(primitives, options):

    fragment = build_types.SourceFragment('twitchsdk', 'broadcast_darwin', os.path.dirname(os.path.realpath(__file__)))

    # Preprocessor defines
    #  <None>

    # Source and header files
    build_tools.add_source_files_recursively(fragment, 'source', ['.cpp', '.mm'], 'Source Files/broadcast/darwin')
    build_tools.add_source_files_recursively(fragment, 'include/twitchsdk/broadcast', ['.h'], 'Header Files/broadcast/darwin')

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include'), is_public=True )

    # Frameworks to link against
    add_frameworks(fragment)

    return fragment


def load_sample_fragment(sample_name, options):
    fragment = build_types.SampleSourceFragment(sample_name, 'broadcast_darwin', os.path.dirname(os.path.realpath(__file__)))

    # Add source and header files
    build_tools.add_source_files_recursively(fragment, 'samples/' + sample_name + '/source', ['.cpp', '.mm'], 'Source Files/broadcast/samples/' + sample_name + '/darwin')
    build_tools.add_source_files_recursively(fragment, 'samples/' + sample_name + '/include/twitchsdk/broadcast', ['.h'], 'Header Files/broadcast/samples/' + sample_name + '/darwin')

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include') )
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'samples', sample_name, 'include') )

    # Frameworks to link against
    add_frameworks(fragment)

    return fragment


def add_frameworks(fragment):
    fragment.add_link_libraries('-framework Accelerate', transform_to_absolute_path=False)
    fragment.add_link_libraries('-framework AVFoundation', transform_to_absolute_path=False)
    fragment.add_link_libraries('-framework AudioToolbox', transform_to_absolute_path=False)
    fragment.add_link_libraries('-framework CoreAudio', transform_to_absolute_path=False)
    fragment.add_link_libraries('-framework CoreGraphics', transform_to_absolute_path=False)
    fragment.add_link_libraries('-framework CoreMedia', transform_to_absolute_path=False)
    fragment.add_link_libraries('-framework CoreVideo', transform_to_absolute_path=False)
    fragment.add_link_libraries('-framework VideoToolbox', transform_to_absolute_path=False)
