/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/audiocapturebase.h"

namespace ttv {
namespace broadcast {
class AppleAudioCapture;
class AppleAudioCaptureInternalData;
}  // namespace broadcast
}  // namespace ttv

class ttv::broadcast::AppleAudioCapture : public AudioCaptureBase {
 public:
  enum class CaptureType { System, Microphone };

 public:
  AppleAudioCapture(CaptureType type);
  virtual ~AppleAudioCapture() override;

 public:  // IAudioCapture
  virtual std::string GetName() const override;
  virtual uint32_t GetNumChannels() const override;
  virtual TTV_ErrorCode Start() override;
  virtual TTV_ErrorCode Stop() override;
  virtual TTV_ErrorCode Process(const std::shared_ptr<IAudioMixer>& mixer, uint64_t& lastSampleTime) override;
  virtual void SetInitialTime(uint64_t initialTime) override;

 private:
  TTV_ErrorCode DoSubmitFrame(uint32_t samplesPerChannel);

  std::unique_ptr<AppleAudioCaptureInternalData> mInternalData;
};
