/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/ivideoencoder.h"

#include <CoreGraphics/CoreGraphics.h>
#include <VideoToolbox/VideoToolbox.h>

namespace ttv {
namespace broadcast {
class AppleVideoEncoder;
class IFrameWriter;
struct Packet;
class AppleVideoEncoderInternalData;
}  // namespace broadcast
}  // namespace ttv

class ttv::broadcast::AppleVideoEncoder : public IVideoEncoder {
 public:
  AppleVideoEncoder(bool enableBFrames);
  virtual ~AppleVideoEncoder() override;

 public:  // IVideoEncoder
  virtual std::string GetName() const override;
  virtual bool SupportsBitRateAdjustment() const override;
  virtual TTV_ErrorCode SetFrameWriter(const std::shared_ptr<IFrameWriter>& frameWriter) override;
  virtual TTV_ErrorCode ValidateVideoParams(const VideoParams& videoParams) const override;
  virtual TTV_ErrorCode Initialize() override;
  virtual TTV_ErrorCode Shutdown() override;
  virtual TTV_ErrorCode Start(uint32_t streamIndex, const VideoParams& vidParams) override;
  virtual TTV_ErrorCode SubmitFrame(const std::shared_ptr<VideoFrame>& videoFrame) override;
  virtual TTV_ErrorCode Stop() override;
  virtual TTV_ErrorCode GetSpsPps(std::vector<uint8_t>& sps, std::vector<uint8_t>& pps) override;
  virtual TTV_ErrorCode ValidateFrame(const std::shared_ptr<VideoFrame>& videoframe) override;
  virtual TTV_ErrorCode SetTargetBitRate(uint32_t kbps) override;
  virtual bool SupportsReceiverProtocol(IVideoFrameReceiver::ReceiverTypeId typeId) const override;
  virtual std::shared_ptr<IVideoFrameReceiver> GetReceiverImplementation(
    IVideoFrameReceiver::ReceiverTypeId typeId) override;

 public:
  void WriteEncodedFrame(std::unique_ptr<Packet>&& packet);

 private:
  void InternalStop();
  OSStatus SetupVTCompressionSession(VTCompressionOutputCallback encodedFrameCallback);
  OSStatus SetupMagicCookie();

  static void MagicCookieEncodedCallback(void* outputCallbackRefCon, void* sourceFrameRefCon, OSStatus status,
    VTEncodeInfoFlags infoFlags, CMSampleBufferRef sampleBuffer);
  static void FrameEncodedCallback(void* outputCallbackRefCon, void* sourceFrameRefCon, OSStatus status,
    VTEncodeInfoFlags infoFlags, CMSampleBufferRef sampleBuffer);

 private:
  std::shared_ptr<AppleVideoEncoderInternalData> mInternalData;
  bool mEnableBFrames;
};
