/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/broadcast/ivideoframereceiver.h"
#include "twitchsdk/broadcast/videoframe.h"

#include <CoreVideo/CoreVideo.h>

#include <memory>

namespace ttv {
namespace broadcast {
class ICVPixelBufferVideoFrameReceiver;
}
}  // namespace ttv

/**
 * The interface used for ICVPixelBufferVideoFrameGenerator to submit their frames to.
 */
class ttv::broadcast::ICVPixelBufferVideoFrameReceiver : public IVideoFrameReceiver {
 public:
  typedef std::function<void(const CVPixelBufferRef buffer)> UnlockFunc;

  /**
   * Packages the given frame data so it can be enqueued for encoding.  When the frame processing of the frame is
   * complete the unlockCallback will be called on an arbitrary thread.
   */
  virtual TTV_ErrorCode PackageFrame(const CVPixelBufferRef buffer, uint64_t timestamp, UnlockFunc unlockCallback,
    std::shared_ptr<VideoFrame>& result) = 0;

  static ReceiverTypeId GetReceiverTypeId() {
    static int typeId = 0;
    return reinterpret_cast<ReceiverTypeId>(&typeId);
  }
};
