/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include <AudioToolbox/AudioToolbox.h>
#include <AudioToolbox/ExtendedAudioFile.h>
#include <OpenAL/al.h>
#include <OpenAL/alc.h>

namespace ttv {
bool LookupOpenAlCaptureFunctions();
ALvoid alcOutputCapturerPrepareProc(ALCuint frequency, ALCenum format, ALCsizei maxsamplecount);
ALvoid alcOutputCapturerStartProc();
ALvoid alcOutputCapturerStopProc();
ALint alcOutputCapturerAvailableSamplesProc();
ALvoid alcOutputCapturerSamplesProc(ALCvoid *buffer, ALCsizei samplecount);
}  // namespace ttv
