/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/broadcast/icvpixelbuffervideoframereceiver.h"
#include "twitchsdk/broadcast/ivideocapture.h"

namespace ttv {
namespace broadcast {
class IRawVideoFrameReceiver;
class IVideoEncoder;

namespace test {
class DarwinTestCameraVideoCapturer;
struct DarwinTestCameraVideoCapturerInternalData;
}  // namespace test
}  // namespace broadcast
}  // namespace ttv

/**
 * A capturer implementation that captures from an available camera.
 * In order for this to work it requires that the app be built with the
 * following Info.plist property set.
 *
 * Privacy - Camera Usage Description
 */
class ttv::broadcast::test::DarwinTestCameraVideoCapturer : public IVideoCapture {
 public:
  enum class CameraType { Default, Front, Back };

 public:
  DarwinTestCameraVideoCapturer(CameraType type);

  virtual std::string GetName() const override;
  virtual TTV_ErrorCode SetVideoEncoder(const std::shared_ptr<IVideoEncoder>& encoder) override;
  virtual TTV_ErrorCode SetFrameQueue(const std::shared_ptr<IVideoFrameQueue>& queue) override;
  virtual TTV_ErrorCode Initialize() override;
  virtual TTV_ErrorCode Start(const VideoParams& videoParams) override;
  virtual TTV_ErrorCode Stop() override;
  virtual TTV_ErrorCode Shutdown() override;

  TTV_ErrorCode SetPreset(const std::string& preset);

 private:
  std::shared_ptr<DarwinTestCameraVideoCapturerInternalData> mInternalData;
};
