/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/testvideocapturer.h"

namespace ttv {
class IThread;

namespace broadcast {
class IRawVideoFrameReceiver;
class IVideoEncoder;

namespace test {
class TestMacDesktopVideoCapturer;
}
}  // namespace broadcast
}  // namespace ttv

/**
 * A simple, ineffecient IVideoCapture implementation which captures the OSX desktop.
 */
class ttv::broadcast::test::TestMacDesktopVideoCapturer : public TestVideoCapturer {
 private:
  virtual std::string GetName() const override;
  virtual void GenerateFrame(uint8_t* buffer, PixelFormat& pixelFormat, bool& requiresVerticalFlip) override;
};
