/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/testmacdesktopvideocapturer.h"

#include <CoreGraphics/CoreGraphics.h>
#include <TargetConditionals.h>

namespace {
#if !TTV_TARGET_IOS
// Scaling function copied from here: http://www.gotow.net/creative/wordpress/?p=7
//
CGImageRef CreateScaledCGImageFromCGImage(CGImageRef image, uint32_t width, uint32_t height) {
  int bitmapBytesPerRow = (width * 4);

  CGColorSpaceRef colorspace = CGImageGetColorSpace(image);
  CGContextRef context =
    CGBitmapContextCreate(NULL, width, height, 8, bitmapBytesPerRow, colorspace, kCGImageAlphaNoneSkipFirst);

  if (context == NULL)
    return nil;

  CGContextDrawImage(context, CGRectMake(0, 0, width, height), image);

  CGImageRef imgRef = CGBitmapContextCreateImage(context);
  CGContextRelease(context);

  return imgRef;
}
#endif
}  // namespace

std::string ttv::broadcast::test::TestMacDesktopVideoCapturer::GetName() const {
  return "TestMacDesktopVideoCapturer";
}

void ttv::broadcast::test::TestMacDesktopVideoCapturer::GenerateFrame(
  uint8_t* buffer, PixelFormat& pixelFormat, bool& requiresVerticalFlip) {
  pixelFormat = PixelFormat::TTV_PF_ARGB;
  requiresVerticalFlip = false;

#if !TTV_TARGET_IOS
  CGImageRef image = CGDisplayCreateImage(CGMainDisplayID());
  size_t displayHeight = CGImageGetHeight(image);
  size_t displayWidth = CGImageGetWidth(image);

  // Rescale if needed
  if (displayHeight != static_cast<size_t>(mVideoParams.outputHeight) ||
      displayWidth != static_cast<size_t>(mVideoParams.outputWidth)) {
    CGImageRef scaledImage = CreateScaledCGImageFromCGImage(image, mVideoParams.outputWidth, mVideoParams.outputHeight);
    CGImageRelease(image);
    image = scaledImage;
  }

  // Extract the bytes
  auto provider = CGImageGetDataProvider(image);
  CFDataRef imageData = CGDataProviderCopyData(provider);

  CFDataGetBytes(imageData, CFRangeMake(0, CFDataGetLength(imageData)), buffer);
  CFRelease(imageData);
  CGImageRelease(image);

#endif
}
