/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/openalsupport.h"

typedef ALvoid AL_APIENTRY (*alcOutputCapturerPrepareProcPtr)(
  ALCuint frequency, ALCenum format, ALCsizei maxsamplecount);
typedef ALvoid AL_APIENTRY (*alcOutputCapturerStartProcPtr)();
typedef ALvoid AL_APIENTRY (*alcOutputCapturerStopProcPtr)();
typedef ALint AL_APIENTRY (*alcOutputCapturerAvailableSamplesProcPtr)();
typedef ALvoid AL_APIENTRY (*alcOutputCapturerSamplesProcPtr)(ALCvoid *buffer, ALCsizei samplecount);

namespace {
alcOutputCapturerPrepareProcPtr gPreparerFunc = nullptr;
alcOutputCapturerStartProcPtr gStartFunc = nullptr;
alcOutputCapturerStopProcPtr gStopFunc = nullptr;
alcOutputCapturerAvailableSamplesProcPtr gAvailableSamplesFunc = nullptr;
alcOutputCapturerSamplesProcPtr gCaptureFunc = nullptr;
}  // namespace

#pragma mark Capture Functions

bool ttv::LookupOpenAlCaptureFunctions() {
  gPreparerFunc =
    reinterpret_cast<alcOutputCapturerPrepareProcPtr>(alcGetProcAddress(nullptr, "alcOutputCapturerPrepare"));
  gStartFunc = reinterpret_cast<alcOutputCapturerStartProcPtr>(alcGetProcAddress(nullptr, "alcOutputCapturerStart"));
  gStopFunc = reinterpret_cast<alcOutputCapturerStopProcPtr>(alcGetProcAddress(nullptr, "alcOutputCapturerStop"));
  gAvailableSamplesFunc = reinterpret_cast<alcOutputCapturerAvailableSamplesProcPtr>(
    alcGetProcAddress(nullptr, "alcOutputCapturerAvailableSamples"));
  gCaptureFunc =
    reinterpret_cast<alcOutputCapturerSamplesProcPtr>(alcGetProcAddress(nullptr, "alcOutputCapturerSamples"));

  // NOTE: The assumption is that all of these function will be available together
  return gPreparerFunc != nullptr;
}

ALvoid ttv::alcOutputCapturerPrepareProc(ALCuint frequency, ALCenum format, ALCsizei maxsamplecount) {
  TTV_ASSERT(gPreparerFunc != nullptr);

  if (gPreparerFunc) {
    gPreparerFunc(frequency, format, maxsamplecount);
  }
}

ALvoid ttv::alcOutputCapturerStartProc() {
  TTV_ASSERT(gStartFunc != nullptr);

  if (gStartFunc != nullptr) {
    gStartFunc();
  }
}

ALvoid ttv::alcOutputCapturerStopProc() {
  TTV_ASSERT(gStopFunc != nullptr);

  if (gStopFunc != nullptr) {
    gStopFunc();
  }
}

ALint ttv::alcOutputCapturerAvailableSamplesProc() {
  TTV_ASSERT(gAvailableSamplesFunc != nullptr);

  if (gAvailableSamplesFunc != nullptr) {
    return gAvailableSamplesFunc();
  }

  return 0;
}

ALvoid ttv::alcOutputCapturerSamplesProc(ALCvoid *buffer, ALCsizei samplecount) {
  TTV_ASSERT(gCaptureFunc != nullptr);

  if (gCaptureFunc != nullptr) {
    gCaptureFunc(buffer, samplecount);
  }
}
