/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/internal/os.h"

#if !TTV_TARGET_IOS
#include <CoreFoundation/CoreFoundation.h>
#endif

namespace ttv {
namespace broadcast {
bool IsValidOSVersion() {
#if !TTV_TARGET_IOS
  return floor(kCFCoreFoundationVersionNumber) >= kCFCoreFoundationVersionNumber10_7;
#else
  return true;
#endif
}

const char* GetOSName() {
#if !TTV_TARGET_IOS
  return "Mac";
#else
  return "iOS";
#endif
}
}  // namespace broadcast
}  // namespace ttv
