/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/ivideoencoder.h"

#include <memory>
#include <vector>

namespace ttv {
namespace broadcast {
class IFrameWriter;
class IntelVideoEncoder;
class IntelVideoEncoderInternalData;
struct Packet;
}  // namespace broadcast
}  // namespace ttv

class ttv::broadcast::IntelVideoEncoder : public IVideoEncoder {
 public:
  IntelVideoEncoder();
  virtual ~IntelVideoEncoder();

 public:
  // IVideoEncoder
  virtual std::string GetName() const override;
  virtual bool SupportsBitRateAdjustment() const override;
  virtual TTV_ErrorCode SetFrameWriter(const std::shared_ptr<IFrameWriter>& frameWriter) override;
  virtual TTV_ErrorCode ValidateVideoParams(const VideoParams& videoParams) const override;
  virtual TTV_ErrorCode Initialize() override;
  virtual TTV_ErrorCode Shutdown() override;
  virtual TTV_ErrorCode Start(uint32_t streamIndex, const VideoParams& videoParams) override;
  virtual TTV_ErrorCode SubmitFrame(const std::shared_ptr<VideoFrame>& videoFrame) override;
  virtual TTV_ErrorCode Stop() override;
  virtual TTV_ErrorCode GetSpsPps(std::vector<uint8_t>& sps, std::vector<uint8_t>& pps) override;
  virtual TTV_ErrorCode ValidateFrame(const std::shared_ptr<VideoFrame>& videoframe) override;
  virtual TTV_ErrorCode SetTargetBitRate(uint32_t kbps) override;
  virtual bool SupportsReceiverProtocol(IVideoFrameReceiver::ReceiverTypeId typeId) const override;
  virtual std::shared_ptr<IVideoFrameReceiver> GetReceiverImplementation(
    IVideoFrameReceiver::ReceiverTypeId typeId) override;

 private:
  void FlushFrames();
  void InternalStop();
  void SetupEncoderParams(const VideoParams& videoParams);
  void DestroyEncodeTaskPool();

 private:
  std::shared_ptr<IntelVideoEncoderInternalData> mInternalData;
};
