package tv.twitch.broadcast;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum AudioFormat {
    None(0),
    PCM(1),
    MP3(20),
    AAC(3);

    private static Map<Integer, AudioFormat> s_Map = new HashMap<Integer, AudioFormat>();

    static {
        EnumSet<AudioFormat> set = EnumSet.allOf(AudioFormat.class);

        for (AudioFormat e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static AudioFormat lookupValue(int val) { return s_Map.get(val); }

    private int m_Value;

    private AudioFormat(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
