package tv.twitch.broadcast;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum AudioSampleFormat {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    TTV_ASF_PCM_S16(0);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, AudioSampleFormat> s_Map = new HashMap<Integer, AudioSampleFormat>();

    static {
        EnumSet<AudioSampleFormat> set = EnumSet.allOf(AudioSampleFormat.class);

        for (AudioSampleFormat e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static AudioSampleFormat lookupValue(int val) {
        AudioSampleFormat err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private AudioSampleFormat(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
