package tv.twitch.broadcast;

import tv.twitch.ErrorCode;

public class BroadcastErrorCode extends ErrorCode {
    public static void forceClassInit() {}

    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    public static final ErrorCode TTV_EC_BROADCAST_BEGIN_ERRORS =
        new BroadcastErrorCode(0x40001, "TTV_EC_BROADCAST_BEGIN_ERRORS");
    public static final ErrorCode TTV_EC_BROADCAST_NOMOREDATA =
        new BroadcastErrorCode(0x40002, "TTV_EC_BROADCAST_NOMOREDATA");
    public static final ErrorCode TTV_EC_BROADCAST_ALIGN16_REQUIRED =
        new BroadcastErrorCode(0x40003, "TTV_EC_BROADCAST_ALIGN16_REQUIRED");
    public static final ErrorCode TTV_EC_BROADCAST_UNSUPPORTED_INPUT_FORMAT =
        new BroadcastErrorCode(0x40004, "TTV_EC_BROADCAST_UNSUPPORTED_INPUT_FORMAT");
    public static final ErrorCode TTV_EC_BROADCAST_UNSUPPORTED_OUTPUT_FORMAT =
        new BroadcastErrorCode(0x40005, "TTV_EC_BROADCAST_UNSUPPORTED_OUTPUT_FORMAT");
    public static final ErrorCode TTV_EC_BROADCAST_INVALID_RESOLUTION =
        new BroadcastErrorCode(0x40006, "TTV_EC_BROADCAST_INVALID_RESOLUTION");
    public static final ErrorCode TTV_EC_BROADCAST_INVALID_FPS =
        new BroadcastErrorCode(0x40007, "TTV_EC_BROADCAST_INVALID_FPS");
    public static final ErrorCode TTV_EC_BROADCAST_INVALID_BITRATE =
        new BroadcastErrorCode(0x40008, "TTV_EC_BROADCAST_INVALID_BITRATE");
    public static final ErrorCode TTV_EC_BROADCAST_INVALID_AUDIO_LAYER =
        new BroadcastErrorCode(0x40009, "TTV_EC_BROADCAST_INVALID_AUDIO_LAYER");
    public static final ErrorCode TTV_EC_BROADCAST_INVALID_VIDEO_CAPTURER =
        new BroadcastErrorCode(0x4000a, "TTV_EC_BROADCAST_INVALID_VIDEO_CAPTURER");
    public static final ErrorCode TTV_EC_BROADCAST_ENCODE_FAILED =
        new BroadcastErrorCode(0x4000b, "TTV_EC_BROADCAST_ENCODE_FAILED");
    public static final ErrorCode TTV_EC_BROADCAST_BUFFER_ALLOCATION_FAILED =
        new BroadcastErrorCode(0x4000c, "TTV_EC_BROADCAST_BUFFER_ALLOCATION_FAILED");
    public static final ErrorCode TTV_EC_BROADCAST_FAILED_TO_INIT_SPEAKER_CAPTURE =
        new BroadcastErrorCode(0x4000d, "TTV_EC_BROADCAST_FAILED_TO_INIT_SPEAKER_CAPTURE");
    public static final ErrorCode TTV_EC_BROADCAST_FRAMES_QUEUEING =
        new BroadcastErrorCode(0x4000e, "TTV_EC_BROADCAST_FRAMES_QUEUEING");
    public static final ErrorCode TTV_EC_BROADCAST_FRAME_QUEUE_FULL =
        new BroadcastErrorCode(0x4000f, "TTV_EC_BROADCAST_FRAME_QUEUE_FULL");
    public static final ErrorCode TTV_EC_BROADCAST_NO_STREAM_KEY =
        new BroadcastErrorCode(0x40010, "TTV_EC_BROADCAST_NO_STREAM_KEY");
    public static final ErrorCode TTV_EC_BROADCAST_INVALID_VIDEOFRAME =
        new BroadcastErrorCode(0x40011, "TTV_EC_BROADCAST_INVALID_VIDEOFRAME");
    public static final ErrorCode TTV_EC_BROADCAST_NO_SPSPPS =
        new BroadcastErrorCode(0x40012, "TTV_EC_BROADCAST_NO_SPSPPS");
    public static final ErrorCode TTV_EC_BROADCAST_NO_D3D_SUPPORT =
        new BroadcastErrorCode(0x40013, "TTV_EC_BROADCAST_NO_D3D_SUPPORT");
    public static final ErrorCode TTV_EC_BROADCAST_NO_INGEST_SERVER_AVAILABLE =
        new BroadcastErrorCode(0x40014, "TTV_EC_BROADCAST_NO_INGEST_SERVER_AVAILABLE");
    public static final ErrorCode TTV_EC_BROADCAST_INVALID_INGEST_SERVER =
        new BroadcastErrorCode(0x40015, "TTV_EC_BROADCAST_INVALID_INGEST_SERVER");
    public static final ErrorCode TTV_EC_BROADCAST_INVALID_ENCODER =
        new BroadcastErrorCode(0x40016, "TTV_EC_BROADCAST_INVALID_ENCODER");
    public static final ErrorCode TTV_EC_BROADCAST_VIDEO_ENCODER_INIT_FAILED =
        new BroadcastErrorCode(0x40017, "TTV_EC_BROADCAST_VIDEO_ENCODER_INIT_FAILED");
    public static final ErrorCode TTV_EC_BROADCAST_AUDIO_ENCODER_INIT_FAILED =
        new BroadcastErrorCode(0x40018, "TTV_EC_BROADCAST_AUDIO_ENCODER_INIT_FAILED");
    public static final ErrorCode TTV_EC_BROADCAST_VIDEO_FRAME_SUBMISSION_FAILED =
        new BroadcastErrorCode(0x40019, "TTV_EC_BROADCAST_VIDEO_FRAME_SUBMISSION_FAILED");
    public static final ErrorCode TTV_EC_BROADCAST_AUDIO_DEVICE_INIT_FAILED =
        new BroadcastErrorCode(0x4001a, "TTV_EC_BROADCAST_AUDIO_DEVICE_INIT_FAILED");
    public static final ErrorCode TTV_EC_BROADCAST_AUDIO_BUFFER_TOO_BIG =
        new BroadcastErrorCode(0x4001b, "TTV_EC_BROADCAST_AUDIO_BUFFER_TOO_BIG");
    public static final ErrorCode TTV_EC_BROADCAST_AUDIO_PASSTHROUGH_NOT_ENABLED =
        new BroadcastErrorCode(0x4001c, "TTV_EC_BROADCAST_AUDIO_PASSTHROUGH_NOT_ENABLED");
    public static final ErrorCode TTV_EC_BROADCAST_INVALID_SAMPLERATE =
        new BroadcastErrorCode(0x4001d, "TTV_EC_BROADCAST_INVALID_SAMPLERATE");
    public static final ErrorCode TTV_EC_BROADCAST_X264_INVALID_PRESET =
        new BroadcastErrorCode(0x4001e, "TTV_EC_BROADCAST_X264_INVALID_PRESET");
    public static final ErrorCode TTV_EC_BROADCAST_X264_INVALID_PROFILE =
        new BroadcastErrorCode(0x4001f, "TTV_EC_BROADCAST_X264_INVALID_PROFILE");
    public static final ErrorCode TTV_EC_BROADCAST_FLV_UNABLE_TO_OPEN_FILE =
        new BroadcastErrorCode(0x40020, "TTV_EC_BROADCAST_FLV_UNABLE_TO_OPEN_FILE");
    public static final ErrorCode TTV_EC_BROADCAST_FLV_FILE_NOT_OPEN =
        new BroadcastErrorCode(0x40021, "TTV_EC_BROADCAST_FLV_FILE_NOT_OPEN");
    public static final ErrorCode TTV_EC_BROADCAST_FLV_UNSUPPORTED_AUDIO_RATE =
        new BroadcastErrorCode(0x40022, "TTV_EC_BROADCAST_FLV_UNSUPPORTED_AUDIO_RATE");
    public static final ErrorCode TTV_EC_BROADCAST_FLV_UNSUPPORTED_AUDIO_IDC =
        new BroadcastErrorCode(0x40023, "TTV_EC_BROADCAST_FLV_UNSUPPORTED_AUDIO_IDC");
    public static final ErrorCode TTV_EC_BROADCAST_FLV_UNSUPPORTED_AUDIO_CODEC =
        new BroadcastErrorCode(0x40024, "TTV_EC_BROADCAST_FLV_UNSUPPORTED_AUDIO_CODEC");
    public static final ErrorCode TTV_EC_BROADCAST_RTMP_REJECTED =
        new BroadcastErrorCode(0x40025, "TTV_EC_BROADCAST_RTMP_REJECTED");
    public static final ErrorCode TTV_EC_BROADCAST_RTMP_WRONG_PROTOCOL_IN_URL =
        new BroadcastErrorCode(0x40026, "TTV_EC_BROADCAST_RTMP_WRONG_PROTOCOL_IN_URL");
    public static final ErrorCode TTV_EC_BROADCAST_RTMP_UNABLE_TO_SEND_DATA =
        new BroadcastErrorCode(0x40027, "TTV_EC_BROADCAST_RTMP_UNABLE_TO_SEND_DATA");
    public static final ErrorCode TTV_EC_BROADCAST_RTMP_INVALID_FLV_PACKET =
        new BroadcastErrorCode(0x40028, "TTV_EC_BROADCAST_RTMP_INVALID_FLV_PACKET");
    public static final ErrorCode TTV_EC_BROADCAST_RTMP_TIMEOUT =
        new BroadcastErrorCode(0x40029, "TTV_EC_BROADCAST_RTMP_TIMEOUT");
    public static final ErrorCode TTV_EC_BROADCAST_MAC_INPUT_Q_SETUP_FAILED =
        new BroadcastErrorCode(0x4002a, "TTV_EC_BROADCAST_MAC_INPUT_Q_SETUP_FAILED");
    public static final ErrorCode TTV_EC_BROADCAST_MAC_INPUT_Q_BUFFER_SETUP_FAILED =
        new BroadcastErrorCode(0x4002b, "TTV_EC_BROADCAST_MAC_INPUT_Q_BUFFER_SETUP_FAILED");
    public static final ErrorCode TTV_EC_BROADCAST_MAC_INPUT_Q_START_FAILED =
        new BroadcastErrorCode(0x4002c, "TTV_EC_BROADCAST_MAC_INPUT_Q_START_FAILED");
    public static final ErrorCode TTV_EC_BROADCAST_INTEL_FAILED_SESSION_INIT =
        new BroadcastErrorCode(0x4002d, "TTV_EC_BROADCAST_INTEL_FAILED_SESSION_INIT");
    public static final ErrorCode TTV_EC_BROADCAST_INTEL_FAILED_VPP_INIT =
        new BroadcastErrorCode(0x4002e, "TTV_EC_BROADCAST_INTEL_FAILED_VPP_INIT");
    public static final ErrorCode TTV_EC_BROADCAST_INTEL_FAILED_ENCODER_INIT =
        new BroadcastErrorCode(0x4002f, "TTV_EC_BROADCAST_INTEL_FAILED_ENCODER_INIT");
    public static final ErrorCode TTV_EC_BROADCAST_INTEL_FAILED_SURFACE_ALLOCATION =
        new BroadcastErrorCode(0x40030, "TTV_EC_BROADCAST_INTEL_FAILED_SURFACE_ALLOCATION");
    public static final ErrorCode TTV_EC_BROADCAST_INTEL_FAILED_TASKPOLL_INIT =
        new BroadcastErrorCode(0x40031, "TTV_EC_BROADCAST_INTEL_FAILED_TASKPOLL_INIT");
    public static final ErrorCode TTV_EC_BROADCAST_INTEL_NO_FREE_TASK =
        new BroadcastErrorCode(0x40032, "TTV_EC_BROADCAST_INTEL_NO_FREE_TASK");
    public static final ErrorCode TTV_EC_BROADCAST_INTEL_NO_FREE_SURFACE =
        new BroadcastErrorCode(0x40033, "TTV_EC_BROADCAST_INTEL_NO_FREE_SURFACE");
    public static final ErrorCode TTV_EC_BROADCAST_LAMEMP3_FAILED_INIT =
        new BroadcastErrorCode(0x40034, "TTV_EC_BROADCAST_LAMEMP3_FAILED_INIT");
    public static final ErrorCode TTV_EC_BROADCAST_LAMEMP3_FAILED_SHUTDOWN =
        new BroadcastErrorCode(0x40035, "TTV_EC_BROADCAST_LAMEMP3_FAILED_SHUTDOWN");
    public static final ErrorCode TTV_EC_BROADCAST_APPLEAAC_FAILED_INIT =
        new BroadcastErrorCode(0x40036, "TTV_EC_BROADCAST_APPLEAAC_FAILED_INIT");
    public static final ErrorCode TTV_EC_BROADCAST_APPLEAAC_FAILED_ENCODING =
        new BroadcastErrorCode(0x40037, "TTV_EC_BROADCAST_APPLEAAC_FAILED_ENCODING");
    public static final ErrorCode TTV_EC_BROADCAST_APPLEAAC_FAILED_SHUTDOWN =
        new BroadcastErrorCode(0x40038, "TTV_EC_BROADCAST_APPLEAAC_FAILED_SHUTDOWN");
    public static final ErrorCode TTV_EC_BROADCAST_INVALID_SUBMISSION_METHOD =
        new BroadcastErrorCode(0x40039, "TTV_EC_BROADCAST_INVALID_SUBMISSION_METHOD");
    public static final ErrorCode TTV_EC_BROADCAST_STREAM_ALREADY_STARTED =
        new BroadcastErrorCode(0x4003a, "TTV_EC_BROADCAST_STREAM_ALREADY_STARTED");
    public static final ErrorCode TTV_EC_BROADCAST_STREAM_NOT_STARTED =
        new BroadcastErrorCode(0x4003b, "TTV_EC_BROADCAST_STREAM_NOT_STARTED");
    public static final ErrorCode TTV_EC_BROADCAST_FRAME_QUEUE_TOO_LONG =
        new BroadcastErrorCode(0x4003c, "TTV_EC_BROADCAST_FRAME_QUEUE_TOO_LONG");
    public static final ErrorCode TTV_EC_BROADCAST_GRAPHICS_API_ERROR =
        new BroadcastErrorCode(0x4003d, "TTV_EC_BROADCAST_GRAPHICS_API_ERROR");
    public static final ErrorCode TTV_EC_BROADCAST_METADATA_CACHE_FULL =
        new BroadcastErrorCode(0x4003e, "TTV_EC_BROADCAST_METADATA_CACHE_FULL");
    public static final ErrorCode TTV_EC_BROADCAST_SOUNDFLOWER_NOT_INSTALLED =
        new BroadcastErrorCode(0x4003f, "TTV_EC_BROADCAST_SOUNDFLOWER_NOT_INSTALLED");
    public static final ErrorCode TTV_EC_BROADCAST_NO_ENCODER_PLUGIN =
        new BroadcastErrorCode(0x40040, "TTV_EC_BROADCAST_NO_ENCODER_PLUGIN");
    public static final ErrorCode TTV_EC_BROADCAST_END_ERRORS =
        new BroadcastErrorCode(0x40041, "TTV_EC_BROADCAST_END_ERRORS");
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private BroadcastErrorCode(int value, String name) { super(value, name); }
}
