package tv.twitch.broadcast;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum BroadcastState {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    Initialized(0), //!< Initialize has been called.
    ReadyToBroadcast(1), //!< Idle and ready to broadcast.
    StartingBroadcast(2), //!< Processing a request to start broadcasting.
    Broadcasting(3), //!< Currently broadcasting.
    StoppingBroadcast(4); //!< Processing a request to stop broadcasting.
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, BroadcastState> s_Map = new HashMap<Integer, BroadcastState>();

    static {
        EnumSet<BroadcastState> set = EnumSet.allOf(BroadcastState.class);

        for (BroadcastState e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static BroadcastState lookupValue(int val) { return s_Map.get(val); }

    private int m_Value;

    private BroadcastState(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
