package tv.twitch.broadcast;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ConnectionType {
    Wifi(0),
    Ethernet(1),
    Cellular(2),
    Unknown(3);

    private static Map<Integer, ConnectionType> s_Map = new HashMap<Integer, ConnectionType>();

    static {
        EnumSet<ConnectionType> set = EnumSet.allOf(ConnectionType.class);

        for (ConnectionType e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static ConnectionType lookupValue(int val) { return s_Map.get(val); }

    private int m_Value;

    private ConnectionType(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
