package tv.twitch.broadcast;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum EncodingCpuUsage {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    Default(0),
    Low(1),
    Medium(2),
    High(3);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, EncodingCpuUsage> s_Map = new HashMap<Integer, EncodingCpuUsage>();

    static {
        EnumSet<EncodingCpuUsage> set = EnumSet.allOf(EncodingCpuUsage.class);

        for (EncodingCpuUsage e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static EncodingCpuUsage lookupValue(int val) {
        EncodingCpuUsage err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private EncodingCpuUsage(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
