package tv.twitch.broadcast;

import tv.twitch.ErrorCode;
import tv.twitch.IModuleListener;
import tv.twitch.StreamInfo;
import tv.twitch.CanTheyError;

/**
 * Listener interface for callbacks from BroadcastAPI.
 */
public interface IBroadcastAPIListener extends IModuleListener {
    /**
     * Fired when the state of the broadcast changes for any reason, solicited or not.
     */
    public void broadcastStateChanged(ErrorCode ec, BroadcastState state);
    /**
     * Fired periodically when there are issues with the user's bandwidth while broadcasting.  If the connection
     * backs up too much then a proper error wil be issues and the broadcast will automatically terminate.  If/when
     * issues have recovered then TTV_EC_SUCCESS will be fired once to clear the warning state.
     *
     * @param ec The severity of the warning.  Possible values are TTV_EC_BROADCAST_FRAMES_QUEUEING,
     *   TTV_EC_BROADCAST_FRAME_QUEUE_TOO_LONG and TTV_EC_SUCCESS.
     * @param backupMilliseconds The number of milliseconds which are backed up on the connection.
     */
    public void broadcastBandwidthWarning(ErrorCode ec, int backupMilliseconds);
    public void broadcastFrameSubmissionIssue(ErrorCode ec);
    public void streamInfoFetched(ErrorCode ec, StreamInfo streamInfo);
    public void streamKeyError(CanTheyError canTheyError);
}
