package tv.twitch.broadcast;

import tv.twitch.ErrorCode;
import tv.twitch.ResultContainer;

public interface IIngestTester {
    /**
     * Retrieves the current state of the test.
     */
    ErrorCode getTestState(ResultContainer<IngestTesterState> result);
    /**
     * Returns the ingest server currently being tested.  If there is no server then TTV_EC_INVALID_STATE will be
     * returned.
     */
    ErrorCode getIngestServer(ResultContainer<IngestServer> result);
    /**
     * Start the testing the given server.
     */
    ErrorCode start(IngestServer ingestServer);
    /**
     * Stop testing the current server and abort the rest of the test.  This will cause the test to fail with error
     * TTV_EC_REQUEST_ABORTED.
     */
    ErrorCode cancel();
    /**
     * Retrieves the computed kilobits (1000 bits) per second of the connection to the ingest server.
     */
    ErrorCode getMeasuredKbps(ResultContainer<Integer> result);
    /**
     * Retrives the error associated with the test, if available.
     */
    ErrorCode getTestError(ResultContainer<ErrorCode> result);
    /**
     * Sets the number of milliseconds in which to test each server.
     */
    ErrorCode setTestDurationMilliseconds(long duration);
    /**
     * Gets the number of milliseconds in which to test each server.
     */
    ErrorCode getTestDurationMilliseconds(ResultContainer<Long> result);
    /**
     * The overall progress between [0,1].
     */
    ErrorCode getProgress(ResultContainer<Float> result);
    /**
     * The owning user id.
     */
    ErrorCode getUserId(ResultContainer<Integer> result);
    /**
     * To be called when done with the instance.
     */
    void dispose();
}
