package tv.twitch.broadcast;

import tv.twitch.ErrorCode;

public interface IVideoCapture {
    public String getName();
    /**
     * Sets the IVideoEncoder that will be used to encode captured frames.
     */
    // public ErrorCode setVideoEncoder(IVideoEncoder encoder);
    /**
     * Sets the IVideoFrameQueue instance to submit frames to once packaged by the IVideoEncoder.
     */
    // public ErrorCode setFrameQueue(IVideoFrameQueue queue);
    /**
     * Initializes the capturer.
     */
    public ErrorCode initialize();
    /**
     * Indicates that frame submission should begin.
     */
    // public ErrorCode start(VideoParams videoParams);
    /**
     * Indicates that frame submission should stop.  Any internal pipeline can be torn down.
     */
    // public ErrorCode stop();
    /**
     * Synchronously stops frame submission and cleans up the internal pipeline.  The IVideoCapture should be disposable
     * after this returns.
     */
    public ErrorCode shutdown();
}
