package tv.twitch.broadcast;

import tv.twitch.CoreErrorCode;
import tv.twitch.ErrorCode;
import tv.twitch.IJniCallable;
import tv.twitch.IJniThreadValidator;
import tv.twitch.NativeProxy;
import tv.twitch.ResultContainer;

/**
 * Proxies a native IIngestTester implementation.
 */
public class IngestTesterProxy extends NativeProxy implements IIngestTester {
    private native ErrorCode GetTestState(long nativeObjectPointer, ResultContainer<IngestTesterState> result);
    private native ErrorCode GetIngestServer(long nativeObjectPointer, ResultContainer<IngestServer> result);
    private native ErrorCode Start(long nativeObjectPointer, IngestServer ingestServer);
    private native ErrorCode Cancel(long nativeObjectPointer);
    private native ErrorCode GetMeasuredKbps(long nativeObjectPointer, ResultContainer<Integer> result);
    private native ErrorCode GetTestError(long nativeObjectPointer, ResultContainer<ErrorCode> result);
    private native ErrorCode SetTestDurationMilliseconds(long nativeObjectPointer, long duration);
    private native ErrorCode GetTestDurationMilliseconds(long nativeObjectPointer, ResultContainer<Long> result);
    private native ErrorCode GetProgress(long nativeObjectPointer, ResultContainer<Float> result);
    private native ErrorCode GetUserId(long nativeObjectPointer, ResultContainer<Integer> result);
    // AND-9927 Disposing an IngestTesterProxy is safe from any thread
    private native void DisposeNativeInstance(long nativeObjectPointer);

    public IngestTesterProxy(long nativeObjectPointer, IJniThreadValidator jniThreadValidator) {
        super(nativeObjectPointer, jniThreadValidator);
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        // AND-9927 Disposing an IngestTesterProxy is safe from any thread
        DisposeNativeInstance(nativeObjectPointer);
    }

    @Override
    public ErrorCode getTestState(final ResultContainer<IngestTesterState> result) {
        final long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
                @Override
                public ErrorCode call() {
                    return GetTestState(ptr, result);
                }
            });
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode getIngestServer(final ResultContainer<IngestServer> result) {
        final long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
                @Override
                public ErrorCode call() {
                    return GetIngestServer(ptr, result);
                }
            });
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode start(final IngestServer ingestServer) {
        final long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
                @Override
                public ErrorCode call() {
                    return Start(ptr, ingestServer);
                }
            });
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode cancel() {
        final long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
                @Override
                public ErrorCode call() {
                    return Cancel(ptr);
                }
            });
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode getMeasuredKbps(final ResultContainer<Integer> result) {
        final long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
                @Override
                public ErrorCode call() {
                    return GetMeasuredKbps(ptr, result);
                }
            });
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode getTestError(final ResultContainer<ErrorCode> result) {
        final long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
                @Override
                public ErrorCode call() {
                    return GetTestError(ptr, result);
                }
            });
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode setTestDurationMilliseconds(final long duration) {
        final long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
                @Override
                public ErrorCode call() {
                    return SetTestDurationMilliseconds(ptr, duration);
                }
            });
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode getTestDurationMilliseconds(final ResultContainer<Long> result) {
        final long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
                @Override
                public ErrorCode call() {
                    return GetTestDurationMilliseconds(ptr, result);
                }
            });
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode getProgress(final ResultContainer<Float> result) {
        final long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
                @Override
                public ErrorCode call() {
                    return GetProgress(ptr, result);
                }
            });
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode getUserId(final ResultContainer<Integer> result) {
        final long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
                @Override
                public ErrorCode call() {
                    return GetUserId(ptr, result);
                }
            });
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}
