package tv.twitch.broadcast;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum IngestTesterState {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    Stopped(0), // Start has not yet been called
    Connecting(1), // Connecting to the ingest server
    Testing(2), // Testing the server
    Disconnecting(3), // Disconnecting from the server
    Finished(4), // Successfully finished the testing
    Failed(5); // The test failed for some reason and has stopped
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, IngestTesterState> s_Map = new HashMap<Integer, IngestTesterState>();

    static {
        EnumSet<IngestTesterState> set = EnumSet.allOf(IngestTesterState.class);

        for (IngestTesterState e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static IngestTesterState lookupValue(int val) {
        IngestTesterState err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private IngestTesterState(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
