package tv.twitch.broadcast;

import tv.twitch.ErrorCode;
import tv.twitch.IJniCallable;
import tv.twitch.IJniThreadChecker;
import tv.twitch.JniThreadValidator;
import tv.twitch.NativeProxy;
import tv.twitch.PassThroughJniThreadValidator;

/**
 * A proxy to the native PassThroughVideoEncoder implementation.
 */
public class PassThroughAudioEncoder extends NativeProxy implements IAudioEncoder {
    /**
     * @Deprecated Use {@link PassThroughVideoEncoder(IJniThreadChecker)}
     */
    public PassThroughAudioEncoder() { super(PassThroughJniThreadValidator.INSTANCE); }

    public PassThroughAudioEncoder(IJniThreadChecker jniThreadChecker) {
        super(new JniThreadValidator(jniThreadChecker));
    }

    private native long CreateNativeInstance();
    // AND-9927 Disposing a PassThroughAudioEncoder is safe from any thread
    private native void DisposeNativeInstance(long nativeObjectPointer);

    private native String GetName(long nativeObjectPointer);
    private native ErrorCode Initialize(long nativeObjectPointer);
    private native ErrorCode Shutdown(long nativeObjectPointer);
    private native ErrorCode SetAudioFormat(long nativeObjectPointer, AudioFormat audioFormat);
    private native ErrorCode SetSamplesPerFrame(long nativeObjectPointer, int samplesPerFrame);

    @Override
    protected long createNativeInstance() {
        return mJniThreadValidator.callJniCallable(new IJniCallable<Long>() {
            @Override
            public Long call() {
                return CreateNativeInstance();
            }
        });
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        // AND-9927 Disposing a PassThroughAudioEncoder is safe from any thread
        DisposeNativeInstance(nativeObjectPointer);
    }

    @Override
    public String getName() {
        return mJniThreadValidator.callJniCallable(new IJniCallable<String>() {
            @Override
            public String call() {
                return GetName(getNativeObjectPointer());
            }
        });
    }

    @Override
    public ErrorCode initialize() {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return Initialize(getNativeObjectPointer());
            }
        });
    }

    @Override
    public ErrorCode shutdown() {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return Shutdown(getNativeObjectPointer());
            }
        });
    }

    public ErrorCode setAudioFormat(final AudioFormat audioFormat) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return SetAudioFormat(getNativeObjectPointer(), audioFormat);
            }
        });
    }

    public ErrorCode setSamplesPerFrame(final int samplesPerFrame) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return SetSamplesPerFrame(getNativeObjectPointer(), samplesPerFrame);
            }
        });
    }
}
