package tv.twitch.broadcast;

import tv.twitch.ErrorCode;
import tv.twitch.NativeProxy;
import tv.twitch.PassThroughJniThreadValidator;

/**
 * A proxy to the native PassThroughVideoCapture implementation.
 * PassThroughVideoCapture is safe to call from any thread, but is not thread-safe, so no two threads must use it at the
 * same time.
 */
public class PassThroughVideoCapture extends NativeProxy implements IVideoCapture {
    public PassThroughVideoCapture() {
        // AND-9927 PassThroughVideoCapture is safe to call from any thread, but is not thread-safe, so no two threads
        // must use it at the same time.
        super(PassThroughJniThreadValidator.INSTANCE);
    }

    // AND-9927 PassThroughVideoCapture is safe to call from any thread, but is not thread-safe, so no two threads must
    // use it at the same time.
    private native long CreateNativeInstance();
    private native void DisposeNativeInstance(long nativeObjectPointer);

    private native String GetName(long nativeObjectPointer);
    private native ErrorCode Initialize(long nativeObjectPointer);
    private native ErrorCode Shutdown(long nativeObjectPointer);
    private native ErrorCode EnqueueVideoPacket(
        long nativeObjectPointer, byte[] videoPacket, boolean keyframe, long timestamp);

    @Override
    protected long createNativeInstance() {
        return CreateNativeInstance();
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        DisposeNativeInstance(nativeObjectPointer);
    }

    @Override
    public String getName() {
        return GetName(getNativeObjectPointer());
    }

    @Override
    public ErrorCode initialize() {
        return Initialize(getNativeObjectPointer());
    }

    @Override
    public ErrorCode shutdown() {
        return Shutdown(getNativeObjectPointer());
    }

    public ErrorCode enqueueVideoPacket(byte[] videoPacket, boolean keyframe, long timestamp) {
        return EnqueueVideoPacket(getNativeObjectPointer(), videoPacket, keyframe, timestamp);
    }
}
