package tv.twitch.broadcast;

import tv.twitch.ErrorCode;
import tv.twitch.JniThreadValidator;
import tv.twitch.NativeProxy;
import tv.twitch.PassThroughJniThreadValidator;

/**
 * A proxy to the native PassThroughVideoEncoder implementation.
 * PassThroughVideoEncoder is safe to call from any thread, but is not thread-safe, so no two threads must use it at the
 * same time.
 */
public class PassThroughVideoEncoder extends NativeProxy implements IVideoEncoder {
    public interface AdjustTargetBitRateFunc { ErrorCode invoke(int kbps); }

    public PassThroughVideoEncoder() {
        // AND-9927 PassThroughVideoEncoder is safe to call from any thread, but is not thread-safe, so no two threads
        // must use it at the same time.
        super(PassThroughJniThreadValidator.INSTANCE);
    }

    // AND-9927 PassThroughVideoEncoder is safe to call from any thread, but is not thread-safe, so no two threads must
    // use it at the same time.
    private native long CreateNativeInstance();
    private native void DisposeNativeInstance(long nativeObjectPointer);

    private native ErrorCode Initialize(long nativeObjectPointer);
    private native ErrorCode Shutdown(long nativeObjectPointer);
    private native String GetName(long nativeObjectPointer);
    private native ErrorCode SetSps(long nativeObjectPointer, byte[] sps);
    private native ErrorCode SetPps(long nativeObjectPointer, byte[] pps);
    private native ErrorCode SetAdjustTargetBitRateFunc(long nativeObjectPointer, AdjustTargetBitRateFunc func);

    @Override
    protected long createNativeInstance() {
        return CreateNativeInstance();
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        DisposeNativeInstance(nativeObjectPointer);
    }

    @Override
    public ErrorCode initialize() {
        return Initialize(getNativeObjectPointer());
    }

    @Override
    public ErrorCode shutdown() {
        return Shutdown(getNativeObjectPointer());
    }

    @Override
    public String getName() {
        return GetName(getNativeObjectPointer());
    }

    public ErrorCode setSps(byte[] sps) { return SetSps(getNativeObjectPointer(), sps); }

    public ErrorCode setPps(byte[] pps) { return SetPps(getNativeObjectPointer(), pps); }

    public ErrorCode setAdjustTargetBitRateFunc(AdjustTargetBitRateFunc func) {
        return SetAdjustTargetBitRateFunc(getNativeObjectPointer(), func);
    }
}
