package tv.twitch.broadcast;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum PixelFormat {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    TTV_PF_BGRA(0x00010203),
    TTV_PF_ABGR(0x01020300),
    TTV_PF_RGBA(0x02010003),
    TTV_PF_ARGB(0x03020100);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, PixelFormat> s_Map = new HashMap<Integer, PixelFormat>();

    static {
        EnumSet<PixelFormat> set = EnumSet.allOf(PixelFormat.class);

        for (PixelFormat e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static PixelFormat lookupValue(int val) {
        PixelFormat err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private PixelFormat(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
