package tv.twitch.broadcast;

import tv.twitch.ErrorCode;
import tv.twitch.ResultContainer;

public class VideoParams {
    public int outputWidth;
    public int outputHeight;
    public int targetFramesPerSecond;
    public int initialKbps;
    public int minimumKbps;
    public int maximumKbps;
    public EncodingCpuUsage encodingCpuUsage;
    public boolean automaticBitRateAdjustmentEnabled;

    public static native ErrorCode configureForBandwidth(int expectedKbps, int framesPerSecond, float bitsPerPixel,
        float aspectRatio, ResultContainer<VideoParams> result);
    public static native ErrorCode configureForResolution(
        int width, int height, int framesPerSecond, float bitsPerPixel, ResultContainer<VideoParams> result);
}
