/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcastlistener.h"
#include "twitchsdk/core/generated/java_all.h"
#include "twitchsdk/core/generated/jni_all.h"
#include "twitchsdk/core/java_nativelistener.h"

namespace ttv {
using namespace ttv::broadcast;

namespace binding {
namespace java {
class JavaBroadcastAPIListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaBroadcastAPIListenerProxy : public NativeModuleListener<IBroadcastAPIListener> {
 public:
  JavaBroadcastAPIListenerProxy(jobject jModule);

 public:
  virtual void BroadcastStateChanged(TTV_ErrorCode ec, BroadcastState state) override;
  virtual void BroadcastBandwidthWarning(TTV_ErrorCode ec, uint32_t backupMilliseconds) override;
  virtual void BroadcastFrameSubmissionIssue(TTV_ErrorCode ec) override;
  virtual void StreamInfoFetched(TTV_ErrorCode ec, const StreamInfo& streamInfo) override;
  virtual void StreamKeyError(const CanTheyError& canTheyError) override;
};
