/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/core/java_coreutil.h"

namespace ttv {
namespace broadcast {
class BroadcastAPI;
class IIngestTester;
class PassThroughVideoCapture;
class PassThroughVideoEncoder;
class PassThroughAudioCapture;
class PassThroughAudioEncoder;
}  // namespace broadcast

namespace binding {
namespace java {
class JavaBroadcastAPIListenerProxy;
class JavaIngestTesterListenerProxy;
class JavaBandwidthStatListenerProxy;

struct BroadcastApiContext {
  std::shared_ptr<ttv::broadcast::BroadcastAPI> broadcastApi;
  std::shared_ptr<JavaBroadcastAPIListenerProxy> nativeListener;
  std::vector<std::shared_ptr<JavaBandwidthStatListenerProxy>> bandwidthListeners;
};
extern JavaNativeProxyRegistry<ttv::broadcast::BroadcastAPI, BroadcastApiContext> gBroadcastApiNativeProxyRegistry;

struct IngestTesterContext {
  std::shared_ptr<ttv::broadcast::IIngestTester> instance;
  std::shared_ptr<JavaIngestTesterListenerProxy> nativeListener;
};
extern JavaNativeProxyRegistry<ttv::broadcast::IIngestTester, IngestTesterContext> gIngestTesterInstanceRegistry;

struct PassThroughVideoCaptureContext {
  std::shared_ptr<ttv::broadcast::PassThroughVideoCapture> instance;
};
extern JavaNativeProxyRegistry<ttv::broadcast::PassThroughVideoCapture, PassThroughVideoCaptureContext>
  gPassThroughVideoCaptureInstanceRegistry;

struct PassThroughVideoEncoderContext {
  std::shared_ptr<ttv::broadcast::PassThroughVideoEncoder> instance;
};
extern JavaNativeProxyRegistry<ttv::broadcast::PassThroughVideoEncoder, PassThroughVideoEncoderContext>
  gPassThroughVideoEncoderInstanceRegistry;

extern JavaNativeProxyRegistry<ttv::broadcast::PassThroughAudioCapture,
  ProxyContext<ttv::broadcast::PassThroughAudioCapture>>
  gPassThroughAudioCaptureInstanceRegistry;
extern JavaNativeProxyRegistry<ttv::broadcast::PassThroughAudioEncoder,
  ProxyContext<ttv::broadcast::PassThroughAudioEncoder>>
  gPassThroughAudioEncoderInstanceRegistry;

void LoadAllBroadcastJavaClassInfo(JNIEnv* jEnv);

jobject GetJavaInstance_BroadcastState(JNIEnv* jEnv, ttv::broadcast::BroadcastState value);
jobject GetJavaInstance_IngestServer(JNIEnv* jEnv, const ttv::broadcast::IngestServer& value);
jobject GetJavaInstance_VideoParams(JNIEnv* jEnv, const ttv::broadcast::VideoParams& value);
jobject GetJavaInstance_BandwidthStat(JNIEnv* jEnv, const ttv::broadcast::BandwidthStat& value);

void GetNativeFromJava_VideoParams(JNIEnv* jEnv, ttv::broadcast::VideoParams& params, jobject jVideoParams);
void GetNativeFromJava_IngestServer(JNIEnv* jEnv, ttv::broadcast::IngestServer& server, jobject jIngestServer);
}  // namespace java
}  // namespace binding
}  // namespace ttv
