/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"
#include "twitchsdk/broadcast/generated/java_bandwidthstat.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_BandwidthStat(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/broadcast/BandwidthStat");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.broadcast.BandwidthStat();

        LookupJavaField(jEnv, info, "recommendedBitsPerSecond", "J"); // public long recommendedBitsPerSecond;
        LookupJavaField(jEnv, info, "measuredBitsPerSecond", "J"); // public long measuredBitsPerSecond;
        LookupJavaField(jEnv, info, "encoderOutputBitsPerSecond", "J"); // public long encoderOutputBitsPerSecond;
        LookupJavaField(jEnv, info, "backBufferSeconds", "D"); // public double backBufferSeconds;
        LookupJavaField(jEnv, info, "recordedTime", "D"); // public double recordedTime;
        LookupJavaField(jEnv, info, "congestionLevel", "D"); // public double congestionLevel;
    }

    return info;
}
