/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"
#include "twitchsdk/broadcast/generated/java_broadcaststate.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_BroadcastState(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/broadcast/BroadcastState");

        LookupJavaStaticMethod(jEnv, info, "lookupValue", "(I)Ltv/twitch/broadcast/BroadcastState;"); // public static tv.twitch.broadcast.BroadcastState lookupValue(int);
        LookupJavaStaticMethod(jEnv, info, "values", "()[Ltv/twitch/broadcast/BroadcastState;"); // public static tv.twitch.broadcast.BroadcastState[] values();
        LookupJavaStaticMethod(jEnv, info, "valueOf", "(Ljava/lang/String;)Ltv/twitch/broadcast/BroadcastState;"); // public static tv.twitch.broadcast.BroadcastState valueOf(java.lang.String);

        LookupJavaMethod(jEnv, info, "getValue", "()I"); // public int getValue();

    }

    return info;
}
