/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"
#include "twitchsdk/broadcast/generated/java_connectiontype.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ConnectionType(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/broadcast/ConnectionType");

        LookupJavaStaticMethod(jEnv, info, "lookupValue", "(I)Ltv/twitch/broadcast/ConnectionType;"); // public static tv.twitch.broadcast.ConnectionType lookupValue(int);
        LookupJavaStaticMethod(jEnv, info, "values", "()[Ltv/twitch/broadcast/ConnectionType;"); // public static tv.twitch.broadcast.ConnectionType[] values();
        LookupJavaStaticMethod(jEnv, info, "valueOf", "(Ljava/lang/String;)Ltv/twitch/broadcast/ConnectionType;"); // public static tv.twitch.broadcast.ConnectionType valueOf(java.lang.String);

        LookupJavaMethod(jEnv, info, "getValue", "()I"); // public int getValue();

    }

    return info;
}
