/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"
#include "twitchsdk/broadcast/generated/java_iaudioencoder.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IAudioEncoder(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/broadcast/IAudioEncoder");

        LookupJavaMethod(jEnv, info, "getName", "()Ljava/lang/String;"); // public abstract java.lang.String getName();
        LookupJavaMethod(jEnv, info, "initialize", "()Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode initialize();
        LookupJavaMethod(jEnv, info, "shutdown", "()Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode shutdown();
    }

    return info;
}
