/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"
#include "twitchsdk/broadcast/generated/java_ibroadcastapilistener.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IBroadcastAPIListener(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/broadcast/IBroadcastAPIListener");

        LookupJavaMethod(jEnv, info, "broadcastStateChanged", "(Ltv/twitch/ErrorCode;Ltv/twitch/broadcast/BroadcastState;)V"); // public abstract void broadcastStateChanged(tv.twitch.ErrorCode, tv.twitch.broadcast.BroadcastState);
        LookupJavaMethod(jEnv, info, "broadcastBandwidthWarning", "(Ltv/twitch/ErrorCode;I)V"); // public abstract void broadcastBandwidthWarning(tv.twitch.ErrorCode, int);
        LookupJavaMethod(jEnv, info, "broadcastFrameSubmissionIssue", "(Ltv/twitch/ErrorCode;)V"); // public abstract void broadcastFrameSubmissionIssue(tv.twitch.ErrorCode);
        LookupJavaMethod(jEnv, info, "streamInfoFetched", "(Ltv/twitch/ErrorCode;Ltv/twitch/StreamInfo;)V"); // public abstract void streamInfoFetched(tv.twitch.ErrorCode, tv.twitch.StreamInfo);
        LookupJavaMethod(jEnv, info, "streamKeyError", "(Ltv/twitch/CanTheyError;)V"); // public abstract void streamKeyError(tv.twitch.CanTheyError);
    }

    return info;
}
