/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"
#include "twitchsdk/broadcast/generated/java_ingestserver.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IngestServer(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/broadcast/IngestServer");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.broadcast.IngestServer();

        LookupJavaField(jEnv, info, "serverId", "I"); // public int serverId;
        LookupJavaField(jEnv, info, "serverName", "Ljava/lang/String;"); // public java.lang.String serverName;
        LookupJavaField(jEnv, info, "serverUrl", "Ljava/lang/String;"); // public java.lang.String serverUrl;
        LookupJavaField(jEnv, info, "priority", "I"); // public int priority;
    }

    return info;
}
