/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"
#include "twitchsdk/broadcast/generated/java_ingesttesterproxy.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IngestTesterProxy(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/broadcast/IngestTesterProxy");

        LookupJavaMethod(jEnv, info, "<init>", "(JLtv/twitch/IJniThreadValidator;)V"); // public tv.twitch.broadcast.IngestTesterProxy(long, tv.twitch.IJniThreadValidator);

        LookupJavaMethod(jEnv, info, "disposeNativeInstance", "(J)V"); // protected void disposeNativeInstance(long);
        LookupJavaMethod(jEnv, info, "getTestState", "(Ltv/twitch/ResultContainer;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode getTestState(tv.twitch.ResultContainer<tv.twitch.broadcast.IngestTesterState>);
        LookupJavaMethod(jEnv, info, "getIngestServer", "(Ltv/twitch/ResultContainer;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode getIngestServer(tv.twitch.ResultContainer<tv.twitch.broadcast.IngestServer>);
        LookupJavaMethod(jEnv, info, "start", "(Ltv/twitch/broadcast/IngestServer;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode start(tv.twitch.broadcast.IngestServer);
        LookupJavaMethod(jEnv, info, "cancel", "()Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode cancel();
        LookupJavaMethod(jEnv, info, "getMeasuredKbps", "(Ltv/twitch/ResultContainer;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode getMeasuredKbps(tv.twitch.ResultContainer<java.lang.Integer>);
        LookupJavaMethod(jEnv, info, "getTestError", "(Ltv/twitch/ResultContainer;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode getTestError(tv.twitch.ResultContainer<tv.twitch.ErrorCode>);
        LookupJavaMethod(jEnv, info, "setTestDurationMilliseconds", "(J)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode setTestDurationMilliseconds(long);
        LookupJavaMethod(jEnv, info, "getTestDurationMilliseconds", "(Ltv/twitch/ResultContainer;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode getTestDurationMilliseconds(tv.twitch.ResultContainer<java.lang.Long>);
        LookupJavaMethod(jEnv, info, "getProgress", "(Ltv/twitch/ResultContainer;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode getProgress(tv.twitch.ResultContainer<java.lang.Float>);
        LookupJavaMethod(jEnv, info, "getUserId", "(Ltv/twitch/ResultContainer;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode getUserId(tv.twitch.ResultContainer<java.lang.Integer>);
        LookupJavaMethod(jEnv, info, "dispose", "()V"); // public void dispose();
    }

    return info;
}
