/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"
#include "twitchsdk/broadcast/generated/java_videoparams.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_VideoParams(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/broadcast/VideoParams");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.broadcast.VideoParams();

        LookupJavaStaticMethod(jEnv, info, "configureForBandwidth", "(IIFFLtv/twitch/ResultContainer;)Ltv/twitch/ErrorCode;"); // public static native tv.twitch.ErrorCode configureForBandwidth(int, int, float, float, tv.twitch.ResultContainer<tv.twitch.broadcast.VideoParams>);
        LookupJavaStaticMethod(jEnv, info, "configureForResolution", "(IIIFLtv/twitch/ResultContainer;)Ltv/twitch/ErrorCode;"); // public static native tv.twitch.ErrorCode configureForResolution(int, int, int, float, tv.twitch.ResultContainer<tv.twitch.broadcast.VideoParams>);

        LookupJavaField(jEnv, info, "outputWidth", "I"); // public int outputWidth;
        LookupJavaField(jEnv, info, "outputHeight", "I"); // public int outputHeight;
        LookupJavaField(jEnv, info, "targetFramesPerSecond", "I"); // public int targetFramesPerSecond;
        LookupJavaField(jEnv, info, "initialKbps", "I"); // public int initialKbps;
        LookupJavaField(jEnv, info, "minimumKbps", "I"); // public int minimumKbps;
        LookupJavaField(jEnv, info, "maximumKbps", "I"); // public int maximumKbps;
        LookupJavaField(jEnv, info, "encodingCpuUsage", "Ltv/twitch/broadcast/EncodingCpuUsage;"); // public tv.twitch.broadcast.EncodingCpuUsage encodingCpuUsage;
        LookupJavaField(jEnv, info, "automaticBitRateAdjustmentEnabled", "Z"); // public boolean automaticBitRateAdjustmentEnabled;
    }

    return info;
}
