/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/java_bandwidthstatlistenerproxy.h"

#include "twitchsdk/broadcast/generated/java_all.h"
#include "twitchsdk/broadcast/java_broadcastutil.h"

using namespace ttv::broadcast;

ttv::binding::java::JavaBandwidthStatListenerProxy::JavaBandwidthStatListenerProxy() {
  mListenerInfo = GetJavaClassInfo_IBandwidthStatListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaBandwidthStatListenerProxy::ReceivedBandwidthStat(const BandwidthStat& stat) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jStat, GetJavaInstance_BandwidthStat(gActiveJavaEnvironment, stat));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["receivedBandwidthStat"], jStat);
}
