/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/java_broadcastapilistenerproxy.h"

#include "twitchsdk/broadcast/generated/java_all.h"
#include "twitchsdk/broadcast/java_broadcastutil.h"

using namespace ttv::broadcast;

ttv::binding::java::JavaBroadcastAPIListenerProxy::JavaBroadcastAPIListenerProxy(jobject jModule)
    : NativeModuleListener(jModule) {
  mListenerInfo = GetJavaClassInfo_IBroadcastAPIListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaBroadcastAPIListenerProxy::BroadcastStateChanged(TTV_ErrorCode ec, BroadcastState state) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jError, GetJavaInstance_ErrorCode(gActiveJavaEnvironment, ec));
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jState, GetJavaInstance_BroadcastState(gActiveJavaEnvironment, state));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["broadcastStateChanged"], jError, jState);
}

void ttv::binding::java::JavaBroadcastAPIListenerProxy::BroadcastBandwidthWarning(
  TTV_ErrorCode ec, uint32_t backupMilliseconds) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jErrorCode, GetJavaInstance_ErrorCode(gActiveJavaEnvironment, ec));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["broadcastBandwidthWarning"], jErrorCode, static_cast<jint>(backupMilliseconds));
}

void ttv::binding::java::JavaBroadcastAPIListenerProxy::BroadcastFrameSubmissionIssue(TTV_ErrorCode ec) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jErrorCode, GetJavaInstance_ErrorCode(gActiveJavaEnvironment, ec));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["broadcastFrameSubmissionIssue"], jErrorCode);
}

void ttv::binding::java::JavaBroadcastAPIListenerProxy::StreamInfoFetched(
  TTV_ErrorCode ec, const StreamInfo& streamInfo) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jErrorCode, GetJavaInstance_ErrorCode(gActiveJavaEnvironment, ec));
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jStreamInfo, GetJavaInstance_StreamInfo(gActiveJavaEnvironment, streamInfo));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["streamInfoFetched"], jErrorCode, jStreamInfo);
}

void ttv::binding::java::JavaBroadcastAPIListenerProxy::StreamKeyError(const CanTheyError& canTheyError) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jCanTheyError, GetJavaInstance_CanTheyError(gActiveJavaEnvironment, canTheyError));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["streamKeyError"], jCanTheyError);
}
