/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/java_broadcastutil.h"

#include "twitchsdk/broadcast/generated/java_all.h"

#include <stdlib.h>

#include <functional>
#include <iostream>

using namespace ttv::broadcast;

ttv::binding::java::JavaNativeProxyRegistry<BroadcastAPI, ttv::binding::java::BroadcastApiContext>
  ttv::binding::java::gBroadcastApiNativeProxyRegistry;
ttv::binding::java::JavaNativeProxyRegistry<IIngestTester, ttv::binding::java::IngestTesterContext>
  ttv::binding::java::gIngestTesterInstanceRegistry;
ttv::binding::java::JavaNativeProxyRegistry<PassThroughVideoEncoder, ttv::binding::java::PassThroughVideoEncoderContext>
  ttv::binding::java::gPassThroughVideoEncoderInstanceRegistry;
ttv::binding::java::JavaNativeProxyRegistry<PassThroughVideoCapture, ttv::binding::java::PassThroughVideoCaptureContext>
  ttv::binding::java::gPassThroughVideoCaptureInstanceRegistry;
ttv::binding::java::JavaNativeProxyRegistry<PassThroughAudioCapture,
  ttv::binding::java::ProxyContext<PassThroughAudioCapture>>
  ttv::binding::java::gPassThroughAudioCaptureInstanceRegistry;
ttv::binding::java::JavaNativeProxyRegistry<PassThroughAudioEncoder,
  ttv::binding::java::ProxyContext<PassThroughAudioEncoder>>
  ttv::binding::java::gPassThroughAudioEncoderInstanceRegistry;

void ttv::binding::java::LoadAllBroadcastJavaClassInfo(JNIEnv* jEnv) {
  // TODO: Auto generate this
  GetJavaClassInfo_PassThroughVideoEncoder_AdjustTargetBitRateFunc(jEnv);

  GetJavaClassInfo_AudioParams(jEnv);
  GetJavaClassInfo_AudioFormat(jEnv);
  GetJavaClassInfo_BroadcastState(jEnv);
  GetJavaClassInfo_BandwidthStat(jEnv);
  GetJavaClassInfo_EncodingCpuUsage(jEnv);
  GetJavaClassInfo_IAudioCapture(jEnv);
  GetJavaClassInfo_IAudioEncoder(jEnv);
  GetJavaClassInfo_IBandwidthStatListener(jEnv);
  GetJavaClassInfo_IBroadcastAPIListener(jEnv);
  GetJavaClassInfo_IIngestTesterListener(jEnv);
  GetJavaClassInfo_IngestServer(jEnv);
  GetJavaClassInfo_IngestTesterState(jEnv);
  GetJavaClassInfo_IngestTesterProxy(jEnv);
  GetJavaClassInfo_IVideoCapture(jEnv);
  GetJavaClassInfo_IVideoEncoder(jEnv);
  GetJavaClassInfo_PixelFormat(jEnv);
  GetJavaClassInfo_VideoParams(jEnv);

  GetJavaClassInfo_FetchIngestListCallback(jEnv);
  GetJavaClassInfo_RunCommercialCallback(jEnv);
  GetJavaClassInfo_SetStreamInfoCallback(jEnv);
  GetJavaClassInfo_StartBroadcastCallback(jEnv);
  GetJavaClassInfo_StopBroadcastCallback(jEnv);
}

jobject ttv::binding::java::GetJavaInstance_BroadcastState(JNIEnv* jEnv, BroadcastState value) {
  JavaClassInfo& info = GetJavaClassInfo_BroadcastState(jEnv);
  return jEnv->CallStaticObjectMethod(info.klass, info.staticMethods["lookupValue"], static_cast<jint>(value));
}

jobject ttv::binding::java::GetJavaInstance_IngestServer(JNIEnv* jEnv, const IngestServer& value) {
  JavaClassInfo& info = GetJavaClassInfo_IngestServer(jEnv);

  jobject jInstance = jEnv->NewObject(info.klass, info.methods["<init>"]);

  AUTO_DELETE_LOCAL_REF(jEnv, jobject, jServerName, GetJavaInstance_String(jEnv, value.serverName));
  jEnv->SetObjectField(jInstance, info.fields["serverName"], jServerName);

  AUTO_DELETE_LOCAL_REF(jEnv, jobject, jServerUrl, GetJavaInstance_String(jEnv, value.serverUrl));
  jEnv->SetObjectField(jInstance, info.fields["serverUrl"], jServerUrl);

  jEnv->SetIntField(jInstance, info.fields["priority"], static_cast<jint>(value.priority));
  jEnv->SetIntField(jInstance, info.fields["serverId"], static_cast<jint>(value.serverId));

  return jInstance;
}

jobject ttv::binding::java::GetJavaInstance_VideoParams(JNIEnv* jEnv, const VideoParams& value) {
  JavaClassInfo& info = GetJavaClassInfo_VideoParams(jEnv);

  jobject jInstance = jEnv->NewObject(info.klass, info.methods["<init>"]);

  jEnv->SetIntField(jInstance, info.fields["outputWidth"], static_cast<jint>(value.outputWidth));
  jEnv->SetIntField(jInstance, info.fields["outputHeight"], static_cast<jint>(value.outputHeight));
  jEnv->SetIntField(jInstance, info.fields["targetFramesPerSecond"], static_cast<jint>(value.targetFramesPerSecond));
  jEnv->SetIntField(jInstance, info.fields["initialKbps"], static_cast<jint>(value.initialKbps));
  jEnv->SetIntField(jInstance, info.fields["minimumKbps"], static_cast<jint>(value.minimumKbps));
  jEnv->SetIntField(jInstance, info.fields["maximumKbps"], static_cast<jint>(value.maximumKbps));

  AUTO_DELETE_LOCAL_REF(jEnv, jobject, jEncodingCpuUsage,
    GetJavaInstance_SimpleEnum(jEnv, GetJavaClassInfo_EncodingCpuUsage(jEnv), value.encodingCpuUsage));
  jEnv->SetObjectField(jInstance, info.fields["encodingCpuUsage"], jEncodingCpuUsage);

  jEnv->SetBooleanField(jInstance, info.fields["automaticBitRateAdjustmentEnabled"],
    static_cast<jint>(value.automaticBitRateAdjustmentEnabled));

  return jInstance;
}

jobject ttv::binding::java::GetJavaInstance_BandwidthStat(JNIEnv* jEnv, const BandwidthStat& stat) {
  JavaClassInfo& info = GetJavaClassInfo_BandwidthStat(jEnv);

  jobject jInstance = jEnv->NewObject(info.klass, info.methods["<init>"]);

  jEnv->SetLongField(
    jInstance, info.fields["recommendedBitsPerSecond"], static_cast<jlong>(stat.recommendedBitsPerSecond));
  jEnv->SetLongField(jInstance, info.fields["measuredBitsPerSecond"], static_cast<jlong>(stat.measuredBitsPerSecond));
  jEnv->SetLongField(
    jInstance, info.fields["encoderOutputBitsPerSecond"], static_cast<jlong>(stat.encoderOutputBitsPerSecond));

  jEnv->SetDoubleField(jInstance, info.fields["backBufferSeconds"], static_cast<jdouble>(stat.backBufferSeconds));
  jEnv->SetDoubleField(jInstance, info.fields["congestionLevel"], static_cast<jdouble>(stat.congestionLevel));
  jEnv->SetDoubleField(jInstance, info.fields["recordedTime"], static_cast<jdouble>(stat.recordedTime));

  return jInstance;
}

void ttv::binding::java::GetNativeFromJava_VideoParams(JNIEnv* jEnv, VideoParams& params, jobject jVideoParams) {
  JavaClassInfo& info = GetJavaClassInfo_VideoParams(jEnv);

  params.outputWidth = static_cast<uint32_t>(jEnv->GetIntField(jVideoParams, info.fields["outputWidth"]));
  params.outputHeight = static_cast<uint32_t>(jEnv->GetIntField(jVideoParams, info.fields["outputHeight"]));
  params.targetFramesPerSecond =
    static_cast<uint32_t>(jEnv->GetIntField(jVideoParams, info.fields["targetFramesPerSecond"]));
  params.initialKbps = static_cast<uint32_t>(jEnv->GetIntField(jVideoParams, info.fields["initialKbps"]));
  params.minimumKbps = static_cast<uint32_t>(jEnv->GetIntField(jVideoParams, info.fields["minimumKbps"]));
  params.maximumKbps = static_cast<uint32_t>(jEnv->GetIntField(jVideoParams, info.fields["maximumKbps"]));

  AUTO_DELETE_LOCAL_REF(
    jEnv, jobject, jEncodingCpuUsage, jEnv->GetObjectField(jVideoParams, info.fields["encodingCpuUsage"]));
  JavaClassInfo& encInfo = GetJavaClassInfo_EncodingCpuUsage(jEnv);
  params.encodingCpuUsage =
    static_cast<EncodingCpuUsage>(jEnv->CallIntMethod(jEncodingCpuUsage, encInfo.methods["getValue"]));

  params.automaticBitRateAdjustmentEnabled =
    jEnv->GetBooleanField(jVideoParams, info.fields["automaticBitRateAdjustmentEnabled"]) != JNI_FALSE;
}

void ttv::binding::java::GetNativeFromJava_IngestServer(JNIEnv* jEnv, IngestServer& server, jobject jIngestServer) {
  JavaClassInfo& info = GetJavaClassInfo_IngestServer(jEnv);

  AUTO_DELETE_LOCAL_REF(jEnv, jstring, jServerName, jEnv->GetObjectField(jIngestServer, info.fields["serverName"]));
  ScopedJavaUTFStringConverter serverName(jEnv, jServerName);
  server.serverName = serverName.GetNativeString();

  AUTO_DELETE_LOCAL_REF(jEnv, jstring, jServerUrl, jEnv->GetObjectField(jIngestServer, info.fields["serverUrl"]));
  ScopedJavaUTFStringConverter serverUrl(jEnv, jServerUrl);
  server.serverUrl = serverUrl.GetNativeString();

  server.priority = static_cast<uint>(jEnv->GetIntField(jIngestServer, info.fields["priority"]));
  server.serverId = static_cast<uint>(jEnv->GetIntField(jIngestServer, info.fields["serverId"]));
}
